/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    public boolean feasible(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        if (optimizable.isMaterializable()) {
            return true;
        }
        return optimizable.supportsMultipleInstantiations();
    }

    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, Optimizable optimizable) throws StandardException {
        if (optimizablePredicateList != null) {
            optimizablePredicateList.transferAllPredicates(optimizablePredicateList2);
            optimizablePredicateList2.classify(optimizable, optimizable.getCurrentAccessPath().getConglomerateDescriptor());
        }
        return optimizablePredicateList2;
    }

    public double nonBasePredicateSelectivity(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList) {
        return 1.0;
    }

    public void putBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2) throws StandardException {
        int n = optimizablePredicateList2.size() - 1;
        while (n >= 0) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList2.getOptPredicate(n);
            optimizablePredicateList.addOptPredicate(optimizablePredicate);
            optimizablePredicateList2.removeOptPredicate(n);
            --n;
        }
    }

    public void estimateCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, CostEstimate costEstimate2) {
        costEstimate2.multiply(costEstimate.rowCount(), costEstimate2);
        optimizer.trace(23, optimizable.getTableNumber(), 0, costEstimate.rowCount(), costEstimate2);
    }

    public double memoryUsage(double d, double d2) {
        return 0.0;
    }

    public String getName() {
        return "NESTEDLOOP";
    }

    public int scanCostType() {
        return 2;
    }

    public String resultSetMethodName(boolean bl) {
        if (bl) {
            return "getBulkTableScanResultSet";
        }
        return "getTableScanResultSet";
    }

    public String joinResultSetMethodName() {
        return "getNestedLoopJoinResultSet";
    }

    public String halfOuterJoinResultSetMethodName() {
        return "getNestedLoopLeftOuterJoinResultSet";
    }

    public int getScanArgs(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n, MethodBuilder methodBuilder2, int n2, int n3, int n4, boolean bl, int n5) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        int n6 = n > 1 ? 25 : 24;
        this.fillInScanArgs1(transactionController, methodBuilder, optimizable, optimizablePredicateList, expressionClassBuilder, methodBuilder2);
        this.fillInScanArgs2(methodBuilder, optimizable, n, n2, n3, n4, bl, n5);
        return n6;
    }

    public void divideUpPredicateLists(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, OptimizablePredicateList optimizablePredicateList3, OptimizablePredicateList optimizablePredicateList4, DataDictionary dataDictionary) throws StandardException {
        optimizablePredicateList.setPredicatesAndProperties(optimizablePredicateList2);
    }

    public boolean doesMaterialization() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    protected boolean validForOutermostTable() {
        return true;
    }
}

