/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class TernaryOperatorNode
extends ValueNode {
    public static final int TRIM = 0;
    public static final int LOCATE = 1;
    public static final int SUBSTRING = 2;
    public static final int LIKE = 3;
    static final String[] TernaryOperators = new String[]{"trim", "LOCATE", "substring", "like"};
    static final String[] TernaryMethodNames = new String[]{"trim", "locate", "substring", "like"};
    static final String[] TernaryResultType = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.BooleanDataValue"};
    static final String[][] TernaryArgType = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "java.lang.Integer"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor"}};
    String operator;
    String methodName;
    int operatorType;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String resultInterfaceType;
    String receiverInterfaceType;
    String leftInterfaceType;
    String rightInterfaceType;
    int trimType;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) {
        this.receiver = (ValueNode)object;
        this.leftOperand = (ValueNode)object2;
        this.rightOperand = (ValueNode)object3;
        this.operatorType = (Integer)object4;
        this.operator = TernaryOperators[this.operatorType];
        this.methodName = TernaryMethodNames[this.operatorType];
        this.resultInterfaceType = TernaryResultType[this.operatorType];
        this.receiverInterfaceType = TernaryArgType[this.operatorType][0];
        this.leftInterfaceType = TernaryArgType[this.operatorType][1];
        this.rightInterfaceType = TernaryArgType[this.operatorType][2];
        if (object5 != null) {
            this.trimType = (Integer)object5;
        }
    }

    public String toString() {
        return "";
    }

    public void setClause(int n) {
        super.setClause(n);
        this.receiver.setClause(n);
        this.leftOperand.setClause(n);
        if (this.rightOperand != null) {
            this.rightOperand.setClause(n);
        }
    }

    public void printSubNodes(int n) {
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, vector);
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, vector);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, vector);
        }
        if (this.operatorType == 0) {
            this.trimBind();
        } else if (this.operatorType == 1) {
            this.locateBind();
        } else if (this.operatorType == 2) {
            this.substrBind();
        }
        return this;
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.receiver = this.receiver.preprocess(n, fromList, subqueryList, predicateList);
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = 0;
        String string = null;
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, this.resultInterfaceType);
        this.receiver.generateExpression(expressionClassBuilder, methodBuilder);
        if (this.operatorType == 0) {
            methodBuilder.push(this.trimType);
            methodBuilder.getField(localField);
            n = 2;
            string = this.receiverInterfaceType;
        } else if (this.operatorType == 1) {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.leftInterfaceType);
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.rightInterfaceType);
            methodBuilder.getField(localField);
            n = 3;
        } else if (this.operatorType == 2) {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.upCast(this.leftInterfaceType);
            if (this.rightOperand != null) {
                this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder);
                methodBuilder.upCast(this.rightInterfaceType);
            } else {
                methodBuilder.pushNull(this.rightInterfaceType);
            }
            methodBuilder.getField(localField);
            methodBuilder.push(this.receiver.getTypeServices().getMaximumWidth());
            n = 4;
            string = this.receiverInterfaceType;
        }
        methodBuilder.callMethod((short)185, string, this.methodName, this.resultInterfaceType, n);
        methodBuilder.putField(localField);
    }

    public void setLeftOperand(ValueNode valueNode) {
        this.leftOperand = valueNode;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode valueNode) {
        this.rightOperand = valueNode;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = this.receiver.categorize(jBitSet, bl);
        boolean bl3 = bl2 = this.leftOperand.categorize(jBitSet, bl) && bl2;
        if (this.rightOperand != null) {
            bl2 = this.rightOperand.categorize(jBitSet, bl) && bl2;
        }
        return bl2;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.receiver = this.receiver.remapColumnReferencesToExpressions();
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public boolean isConstantExpression() {
        return this.receiver.isConstantExpression() && this.leftOperand.isConstantExpression() && (this.rightOperand == null || this.rightOperand.isConstantExpression());
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.receiver.constantExpression(predicateList) && this.leftOperand.constantExpression(predicateList) && (this.rightOperand == null || this.rightOperand.constantExpression(predicateList));
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.receiver != null && !visitor.stopTraversal()) {
            this.receiver = (ValueNode)this.receiver.accept(visitor);
        }
        if (this.leftOperand != null && !visitor.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(visitor);
        }
        if (this.rightOperand != null && !visitor.stopTraversal()) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(visitor);
        }
        return visitable;
    }

    private ValueNode trimBind() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = TypeId.getBuiltInTypeId(12);
        if (this.receiver.isParameterNode()) {
            ((ParameterNode)this.receiver).setDescriptor(this.getVarcharDescriptor());
        }
        if (this.leftOperand.isParameterNode()) {
            ((ParameterNode)this.leftOperand).setDescriptor(this.getVarcharDescriptor());
        }
        this.bindToBuiltIn();
        TypeId typeId3 = this.receiver.getTypeId();
        if (typeId3.userType()) {
            this.throwBadType("trim", typeId3.getSQLTypeName());
        }
        this.receiver = this.castArgToString(this.receiver);
        if (typeId3.getTypeFormatId() == 444 || typeId3.getTypeFormatId() == 448) {
            typeId2 = typeId3;
        }
        if ((typeId = this.leftOperand.getTypeId()).userType()) {
            this.throwBadType("trim", typeId.getSQLTypeName());
        }
        this.leftOperand = this.castArgToString(this.leftOperand);
        this.setResultType(typeId2);
        return this;
    }

    private void setResultType(TypeId typeId) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, true, this.receiver.getTypeServices().getMaximumWidth()));
    }

    public ValueNode locateBind() throws StandardException {
        if (this.receiver.isParameterNode()) {
            if (this.leftOperand.isParameterNode()) {
                ((ParameterNode)this.receiver).setDescriptor(this.getVarcharDescriptor());
            } else if (this.leftOperand.getTypeId().isStringTypeId()) {
                ((ParameterNode)this.receiver).setDescriptor(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.isParameterNode()) {
            if (this.receiver.isParameterNode()) {
                ((ParameterNode)this.leftOperand).setDescriptor(this.getVarcharDescriptor());
            } else if (this.receiver.getTypeId().isStringTypeId()) {
                ((ParameterNode)this.leftOperand).setDescriptor(this.receiver.getTypeServices());
            }
        }
        if (this.rightOperand.isParameterNode()) {
            ((ParameterNode)this.rightOperand).setDescriptor(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        TypeId typeId3 = this.receiver.getTypeId();
        if (!typeId3.isStringTypeId() || !typeId.isStringTypeId() || typeId2.getJDBCTypeId() != 4) {
            throw StandardException.newException("42884", "LOCATE", (Object)"FUNCTION");
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.receiver.getTypeServices().isNullable()));
        return this;
    }

    protected ValueNode castArgToString(ValueNode valueNode) throws StandardException {
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        if (!valueNode.getTypeId().isStringTypeId()) {
            ValueNode valueNode2 = (ValueNode)this.getNodeFactory().getNode(60, valueNode, DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, typeCompiler.getCastToCharWidth(valueNode.getTypeServices())), this.getContextManager());
            ((CastNode)valueNode2).bindCastNodeOnly();
            return valueNode2;
        }
        return valueNode;
    }

    public ValueNode substrBind() throws StandardException {
        TypeId typeId;
        if (this.receiver.isParameterNode()) {
            ((ParameterNode)this.receiver).setDescriptor(this.getVarcharDescriptor());
        }
        if (this.leftOperand.isParameterNode()) {
            ((ParameterNode)this.leftOperand).setDescriptor(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        if (this.rightOperand != null && this.rightOperand.isParameterNode()) {
            ((ParameterNode)this.rightOperand).setDescriptor(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        if (!this.leftOperand.getTypeId().isNumericTypeId() || this.rightOperand != null && !this.rightOperand.getTypeId().isNumericTypeId()) {
            throw StandardException.newException("42884", "SUBSTR", (Object)"FUNCTION");
        }
        TypeId typeId2 = typeId = this.receiver.getTypeId();
        switch (typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                this.throwBadType("SUBSTR", typeId.getSQLTypeName());
            }
        }
        int n = this.receiver.getTypeServices().getMaximumWidth();
        if (this.rightOperand != null && this.rightOperand instanceof ConstantNode && ((ConstantNode)this.rightOperand).getValue().getInt() < n) {
            n = ((ConstantNode)this.rightOperand).getValue().getInt();
        }
        this.setType(new DataTypeDescriptor(typeId2, true, n));
        return this;
    }

    public ValueNode getReceiver() {
        return this.receiver;
    }

    private void throwBadType(String string, String string2) throws StandardException {
        throw StandardException.newException("42X25", string, (Object)string2);
    }

    protected void bindToBuiltIn() throws StandardException {
        if (!this.receiver.getTypeId().systemBuiltIn()) {
            this.receiver = this.receiver.genSQLJavaSQLTree();
        }
        if (!this.leftOperand.getTypeId().systemBuiltIn()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().systemBuiltIn()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
    }

    private DataTypeDescriptor getVarcharDescriptor() {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true);
    }
}

