/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Timestamp;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class CreateTriggerConstantAction
extends DDLSingleTableConstantAction {
    private String triggerName;
    private String triggerSchemaName;
    private TableDescriptor triggerTable;
    private UUID triggerTableId;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private boolean referencingOld;
    private boolean referencingNew;
    private UUID whenSPSId;
    private String whenText;
    private UUID actionSPSId;
    private String actionText;
    private String originalActionText;
    private String oldReferencingName;
    private String newReferencingName;
    private UUID spsCompSchemaId;
    private Timestamp creationTimestamp;
    private int[] referencedCols;

    public void executeConstantAction(Activation activation) throws StandardException {
        String string;
        SPSDescriptor sPSDescriptor = null;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.triggerSchemaName);
        if (this.triggerTable != null) {
            this.triggerTableId = this.triggerTable.getUUID();
            string = this.triggerTable.getName();
        } else {
            string = "with UUID " + this.triggerTableId;
        }
        this.triggerTable = dataDictionary.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", string);
        }
        this.lockTableForDDL(transactionController, this.triggerTable.getHeapConglomerateId(), true);
        this.triggerTable = dataDictionary.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", string);
        }
        dependencyManager.invalidateFor(this.triggerTable, 28, languageConnectionContext);
        UUID uUID = dataDictionary.getUUIDFactory().createUUID();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (this.whenText != null) {
            sPSDescriptor = this.createSPS(languageConnectionContext, dataDescriptorGenerator, dataDictionary, transactionController, uUID, schemaDescriptor, this.whenSPSId, this.spsCompSchemaId, this.whenText, true, this.triggerTable);
        }
        SPSDescriptor sPSDescriptor2 = this.createSPS(languageConnectionContext, dataDescriptorGenerator, dataDictionary, transactionController, uUID, schemaDescriptor, this.actionSPSId, this.spsCompSchemaId, this.actionText, false, this.triggerTable);
        TriggerDescriptor triggerDescriptor = dataDescriptorGenerator.newTriggerDescriptor(schemaDescriptor, uUID, this.triggerName, this.eventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTable, sPSDescriptor == null ? null : sPSDescriptor.getUUID(), sPSDescriptor2.getUUID(), this.creationTimestamp == null ? new Timestamp(System.currentTimeMillis()) : this.creationTimestamp, this.referencedCols, this.originalActionText, this.referencingOld, this.referencingNew, this.oldReferencingName, this.newReferencingName);
        dataDictionary.addDescriptor(triggerDescriptor, schemaDescriptor, 13, false, transactionController);
        if (sPSDescriptor != null) {
            dependencyManager.addDependency(triggerDescriptor, sPSDescriptor, languageConnectionContext.getContextManager());
        }
        dependencyManager.addDependency(triggerDescriptor, sPSDescriptor2, languageConnectionContext.getContextManager());
        dependencyManager.addDependency(triggerDescriptor, this.triggerTable, languageConnectionContext.getContextManager());
        dependencyManager.addDependency(sPSDescriptor2, this.triggerTable, languageConnectionContext.getContextManager());
    }

    private SPSDescriptor createSPS(LanguageConnectionContext languageConnectionContext, DataDescriptorGenerator dataDescriptorGenerator, DataDictionary dataDictionary, TransactionController transactionController, UUID uUID, SchemaDescriptor schemaDescriptor, UUID uUID2, UUID uUID3, String string, boolean bl, TableDescriptor tableDescriptor) throws StandardException {
        if (string == null) {
            return null;
        }
        String string2 = "TRIGGER" + (bl ? "WHEN_" : "ACTN_") + uUID + "_" + tableDescriptor.getUUID().toString();
        SPSDescriptor sPSDescriptor = new SPSDescriptor(dataDictionary, string2, uUID2 == null ? dataDictionary.getUUIDFactory().createUUID() : uUID2, schemaDescriptor.getUUID(), uUID3 == null ? languageConnectionContext.getDefaultSchema().getUUID() : uUID3, 'T', true, string, null, null, true);
        sPSDescriptor.prepareAndRelease(languageConnectionContext, tableDescriptor);
        dataDictionary.addSPSDescriptor(sPSDescriptor, transactionController, true);
        return sPSDescriptor;
    }

    public String toString() {
        return this.constructToString("CREATE TRIGGER ", this.triggerName);
    }

    CreateTriggerConstantAction(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, TableDescriptor tableDescriptor, UUID uUID, String string3, UUID uUID2, String string4, UUID uUID3, Timestamp timestamp, int[] nArray, String string5, boolean bl4, boolean bl5, String string6, String string7) {
        super(tableDescriptor.getUUID());
        this.triggerName = string2;
        this.triggerSchemaName = string;
        this.triggerTable = tableDescriptor;
        this.eventMask = n;
        this.isBefore = bl;
        this.isRow = bl2;
        this.isEnabled = bl3;
        this.whenSPSId = uUID;
        this.whenText = string3;
        this.actionSPSId = uUID2;
        this.actionText = string4;
        this.spsCompSchemaId = uUID3;
        this.creationTimestamp = timestamp;
        this.referencedCols = nArray;
        this.originalActionText = string5;
        this.referencingOld = bl4;
        this.referencingNew = bl5;
        this.oldReferencingName = string6;
        this.newReferencingName = string7;
    }
}

