/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class UpdateStatisticsConstantAction
extends DDLConstantAction {
    private static final int GROUP_FETCH_SIZE = 16;
    private UUID tableUUID;
    private UUID[] objectUUID;
    private String objectName;
    private boolean forTable;
    private long[] conglomerateNumber;
    private ExecIndexRow[] indexRow;
    private DataValueDescriptor[][] rowBufferArray;
    private DataValueDescriptor[] rowBuffer;
    private DataValueDescriptor[] lastUniqueKey;

    public String toString() {
        return "UPDATE STATISTICS FOR " + (this.forTable ? "TABLE" : "INDEX") + " " + this.objectName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        GenericScanController genericScanController = null;
        TransactionController transactionController = activation.getTransactionController();
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableUUID);
        dependencyManager.invalidateFor(tableDescriptor, 40, languageConnectionContext);
        int n = 0;
        while (n < this.conglomerateNumber.length) {
            if (this.conglomerateNumber[n] != -1L) {
                int n2;
                int n3 = this.indexRow[n].nColumns() - 1;
                long[] lArray = new long[n3];
                long l = 0L;
                this.initializeRowBuffers(this.indexRow[n]);
                try {
                    genericScanController = transactionController.openGroupFetchScan(this.conglomerateNumber[n], false, 0, 6, 1, null, null, 0, null, null, 0);
                    boolean bl = true;
                    n2 = 0;
                    while ((n2 = genericScanController.fetchNextGroup(this.rowBufferArray, null)) > 0) {
                        int n4 = 0;
                        while (n4 < n2) {
                            int n5 = this.compareWithPrevKey(n4, bl);
                            bl = false;
                            if (n5 >= 0) {
                                int n6 = n5;
                                while (n6 < lArray.length) {
                                    int n7 = n6++;
                                    lArray[n7] = lArray[n7] + 1L;
                                }
                            }
                            ++l;
                            ++n4;
                        }
                        DataValueDescriptor[] dataValueDescriptorArray = this.rowBufferArray[15];
                        this.rowBufferArray[15] = this.lastUniqueKey;
                        this.lastUniqueKey = dataValueDescriptorArray;
                    }
                }
                finally {
                    Object var14_12 = null;
                    if (genericScanController != null) {
                        genericScanController.close();
                        genericScanController = null;
                    }
                }
                if (l == 0L) break;
                dataDictionary.dropStatisticsDescriptors(this.tableUUID, this.objectUUID[n], transactionController);
                n2 = 0;
                while (n2 < this.indexRow[n].nColumns() - 1) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), this.objectUUID[n], this.tableUUID, "I", new StatisticsImpl(l, lArray[n2]), n2 + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void initializeRowBuffers(ExecIndexRow execIndexRow) {
        this.rowBufferArray = new DataValueDescriptor[16][];
        this.lastUniqueKey = execIndexRow.getRowArrayClone();
        this.rowBufferArray[0] = execIndexRow.getRowArray();
    }

    private int compareWithPrevKey(int n, boolean bl) throws StandardException {
        if (bl) {
            return 0;
        }
        DataValueDescriptor[] dataValueDescriptorArray = n == 0 ? this.lastUniqueKey : this.rowBufferArray[n - 1];
        DataValueDescriptor[] dataValueDescriptorArray2 = this.rowBufferArray[n];
        int n2 = 0;
        while (n2 < dataValueDescriptorArray.length - 1) {
            DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[n2];
            if (dataValueDescriptor.isNull()) {
                return n2;
            }
            if (dataValueDescriptorArray[n2].compare(dataValueDescriptorArray2[n2]) != 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public UpdateStatisticsConstantAction() {
    }

    public UpdateStatisticsConstantAction(boolean bl, String string, UUID uUID, UUID[] uUIDArray, long[] lArray, ExecIndexRow[] execIndexRowArray) {
        this.forTable = bl;
        this.objectName = string;
        this.tableUUID = uUID;
        this.objectUUID = uUIDArray;
        this.conglomerateNumber = lArray;
        this.indexRow = execIndexRowArray;
    }
}

