/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.IFastPath;
import org.apache.derby.vti.IQualifyable;
import org.apache.derby.vti.Pushable;
import org.apache.derby.vti.VTIEnvironment;

public class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private boolean next;
    private ClassInspector classInspector;
    private GeneratedMethod row;
    private GeneratedMethod constructor;
    protected GeneratedMethod closeCleanup;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private FormatableHashtable compileTimeConstants;
    private int ctcNumber;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private int scanIsolationLevel = 0;

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                Object object;
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    object = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = object.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    object = (IQualifyable)((Object)this.userPS);
                    object.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    object = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(((UpdatableVTIConstantAction)object).statementType, ((WriteCursorConstantAction)object).deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
            }
            this.setNullableColumnList();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private boolean[] setNullableColumnList() throws SQLException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = this.userVTI.getMetaData();
        boolean[] blArray = new boolean[resultSetMetaData.getColumnCount() + 1];
        int n = 1;
        while (n < blArray.length) {
            blArray[n] = resultSetMetaData.isNullable(n) != 0;
            ++n;
        }
        this.runtimeNullableColumn = blArray;
        return blArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        } else {
            this.close();
            this.openCore();
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            try {
                int n;
                if (this.userVTI == null && this.fastPath != null && (n = this.fastPath.nextRow((execRow = this.getAllocatedRow()).getRowArray())) != 0) {
                    if (n == -1) {
                        execRow = null;
                    } else if (n == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null) {
                    if (!this.userVTI.next()) {
                        if (this.fastPath != null) {
                            this.fastPath.rowsDone();
                        }
                        execRow = null;
                    } else {
                        execRow = this.getAllocatedRow();
                        this.populateFromResultSet(execRow);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, execRow.getRowArray());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        this.setCurrentRow(execRow);
        if (execRow != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            Object var2_1;
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.clearCurrentRow();
            this.next = false;
            if (this.userVTI != null) {
                try {
                    try {
                        this.userVTI.close();
                    }
                    catch (SQLException sQLException) {
                        throw StandardException.unexpectedUserException(sQLException);
                    }
                    var2_1 = null;
                    this.userVTI = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.userVTI = null;
                    throw throwable;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    try {
                        this.userPS.close();
                    }
                    catch (SQLException sQLException) {
                        throw StandardException.unexpectedUserException(sQLException);
                    }
                    var2_1 = null;
                    this.userPS = null;
                }
                catch (Throwable throwable) {
                    var2_1 = null;
                    this.userPS = null;
                    throw throwable;
                }
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        }
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return l;
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public ExecRow getCurrentRow() {
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet formatableBitSet = this.referencedColumns;
        int n = formatableBitSet.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (formatableBitSet.isSet(n3)) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (formatableBitSet.isSet(n5)) {
                nArray[n4++] = n5 + 1;
            }
            ++n5;
        }
        return nArray;
    }

    public void populateFromResultSet(ExecRow execRow) throws StandardException {
        try {
            boolean[] blArray = this.setNullableColumnList();
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            int n = 1;
            int n2 = 0;
            while (n2 < dataValueDescriptorArray.length) {
                if (this.referencedColumns != null && !this.referencedColumns.get(n2)) {
                    if (!this.pushedProjection) {
                        ++n;
                    }
                } else {
                    dataValueDescriptorArray[n2].setValueFromResultSet(this.userVTI, n, blArray[n]);
                    ++n;
                }
                ++n2;
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public final boolean isCompileTime() {
        return false;
    }

    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getSource();
    }

    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getScanIsolationLevel()];
    }

    public final void setSharedState(String string, Serializable serializable) {
        if (string == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = this.activation.getPreparedStatement().getSavedObjects();
            synchronized (objectArray2) {
                this.compileTimeConstants = (FormatableHashtable)objectArray[this.ctcNumber];
                if (this.compileTimeConstants == null) {
                    this.compileTimeConstants = new FormatableHashtable();
                    objectArray[this.ctcNumber] = this.compileTimeConstants;
                }
            }
        }
        if (serializable == null) {
            this.compileTimeConstants.remove(string);
        } else {
            this.compileTimeConstants.put(string, serializable);
        }
    }

    public Object getSharedState(String string) {
        if (string == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(string);
    }

    VTIResultSet(Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, String string, Qualifier[][] qualifierArray, int n2, boolean bl, boolean bl2, int n3, boolean bl3, int n4, double d, double d2, GeneratedMethod generatedMethod3) throws StandardException {
        super(activation, n, d, d2);
        this.row = generatedMethod;
        this.constructor = generatedMethod2;
        this.javaClassName = string;
        this.version2 = bl;
        this.reuseablePs = bl2;
        this.isTarget = bl3;
        this.pushedQualifiers = qualifierArray;
        this.scanIsolationLevel = n4;
        if (n2 != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n2);
        }
        this.ctcNumber = n3;
        this.compileTimeConstants = (FormatableHashtable)activation.getPreparedStatement().getSavedObject(n3);
        this.closeCleanup = generatedMethod3;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }
}

