/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeMaxScan;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.impl.store.access.btree.index.B2IUndo;

public class B2IMaxScan
extends BTreeMaxScan {
    private ConglomerateController base_cc_for_locking;

    public void close() throws StandardException {
        super.close();
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
    }

    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        boolean bl2 = super.closeForEndTransaction(bl);
        if (this.base_cc_for_locking != null) {
            this.base_cc_for_locking.close();
            this.base_cc_for_locking = null;
        }
        return bl2;
    }

    public void init(TransactionManager transactionManager, Transaction transaction, int n, int n2, LockingPolicy lockingPolicy, int n3, boolean bl, FormatableBitSet formatableBitSet, B2I b2I, B2IUndo b2IUndo) throws StandardException {
        int n4 = n | 0x40;
        this.base_cc_for_locking = transactionManager.openConglomerate(b2I.baseConglomerateId, false, n4, n2, n3);
        BTreeLockingPolicy bTreeLockingPolicy = b2I.getBtreeLockingPolicy(transaction, n2, n, n3, this.base_cc_for_locking, this);
        super.init(transactionManager, transaction, false, n, n2, bTreeLockingPolicy, formatableBitSet, null, 0, null, null, 0, b2I, b2IUndo, null, null);
    }

    B2IMaxScan() {
    }
}

