/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapController;

class HeapPostCommit
implements Serviceable {
    private AccessFactory access_factory = null;
    private Heap heap = null;
    private long page_number = -1L;

    private final void purgeCommittedDeletes(HeapController heapController, long l) throws StandardException {
        Page page = heapController.getUserPageWait(l);
        boolean bl = false;
        if (page != null) {
            block8: {
                try {
                    int n = page.recordCount() - page.nonDeletedRecordCount();
                    if (n > 0) {
                        int n2 = page.recordCount() - 1;
                        while (n2 >= 0) {
                            RecordHandle recordHandle;
                            boolean bl2 = page.isDeletedAtSlot(n2);
                            if (bl2 && (bl2 = heapController.lockRowAtSlotNoWaitExclusive(recordHandle = page.fetchFromSlot(null, n2, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) {
                                bl = true;
                                page.purgeAtSlot(n2, 1, false);
                            }
                            --n2;
                        }
                    }
                    if (page.recordCount() != 0) break block8;
                    bl = true;
                    heapController.removePage(page);
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (!bl) {
                        page.unlatch();
                        page = null;
                    }
                    throw throwable;
                }
            }
            Object var7_9 = null;
            if (!bl) {
                page.unlatch();
                page = null;
            }
        }
    }

    public boolean serviceASAP() {
        return true;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public int performWork(ContextManager contextManager) throws StandardException {
        boolean bl;
        TransactionManager transactionManager;
        block2: {
            TransactionManager transactionManager2 = (TransactionManager)this.access_factory.getAndNameTransaction(contextManager, "SystemTransaction");
            transactionManager = transactionManager2.getInternalTransaction();
            bl = false;
            try {
                HeapController heapController = (HeapController)this.heap.open(transactionManager, transactionManager.getRawStoreXact(), false, 132, 6, transactionManager.getRawStoreXact().newLockingPolicy(1, 4, true), this.heap, null);
                this.purgeCommittedDeletes(heapController, this.page_number);
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("40XL1") && !standardException.getMessageId().equals("40001")) break block2;
                bl = true;
            }
        }
        transactionManager.commitNoSync(1);
        transactionManager.destroy();
        return bl ? 2 : 1;
    }

    HeapPostCommit(AccessFactory accessFactory, Heap heap, long l) {
        this.access_factory = accessFactory;
        this.heap = heap;
        this.page_number = l;
    }
}

