/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.AllocExtent;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.StoredPage;

public class AllocPage
extends StoredPage {
    public static final int FORMAT_NUMBER = 118;
    protected static final int ALLOC_PAGE_HEADER_OFFSET = 60;
    protected static final int ALLOC_PAGE_HEADER_SIZE = 48;
    protected static final int BORROWED_SPACE_OFFSET = 108;
    protected static final int BORROWED_SPACE_LEN = 1;
    protected static final int MAX_BORROWED_SPACE = 204;
    public static final String TEST_MULTIPLE_ALLOC_PAGE = null;
    private long nextAllocPageNumber;
    private long nextAllocPageOffset;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private long reserved4;
    private AllocExtent extent;
    private int borrowedSpace;

    public int getTypeFormatId() {
        return 118;
    }

    protected int getMaxFreeSpace() {
        return super.getMaxFreeSpace() - 48 - 1 - this.borrowedSpace;
    }

    protected void createPage(PageKey pageKey, int[] nArray) throws StandardException {
        super.createPage(pageKey, nArray);
        int n = nArray[2];
        int n2 = nArray[5];
        this.borrowedSpace = nArray[4];
        this.pageData[108] = (byte)this.borrowedSpace;
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        this.nextAllocPageNumber = -1L;
        this.nextAllocPageOffset = 0L;
        this.reserved4 = 0L;
        this.reserved3 = 0L;
        this.reserved2 = 0L;
        this.reserved1 = 0L;
        int n3 = this.getMaxFreeSpace();
        this.extent = this.createExtent(pageKey.getPageNumber() + 1L, n, 0, n3);
    }

    private AllocExtent createExtent(long l, int n, int n2, int n3) {
        int n4 = AllocExtent.MAX_RANGE(n3);
        return new AllocExtent(l * (long)n, l, n2, n, n4);
    }

    protected void initFromData(FileContainer fileContainer, PageKey pageKey) throws StandardException {
        int n;
        if (this.pageData.length < 109) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
        }
        this.borrowedSpace = n = this.pageData[108];
        if (this.pageData.length < 109 + n) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", pageKey));
        }
        if (this.borrowedSpace > 0) {
            this.clearSection(109, this.borrowedSpace);
        }
        super.initFromData(fileContainer, pageKey);
        try {
            this.readAllocPageHeader();
            int n2 = 109 + this.borrowedSpace;
            this.extent = this.readExtent(n2);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", classNotFoundException, (Object)pageKey));
        }
    }

    protected void writePage(PageKey pageKey) throws StandardException {
        try {
            this.updateAllocPageHeader();
            byte by = this.pageData[108];
            if (by > 0) {
                this.clearSection(109, by);
            }
            int n = 109 + by;
            this.writeExtent(n);
        }
        catch (IOException iOException) {
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDB0.D", iOException, (Object)pageKey));
        }
        super.writePage(pageKey);
    }

    private void readAllocPageHeader() throws IOException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        arrayInputStream.setPosition(60);
        this.nextAllocPageNumber = arrayInputStream.readLong();
        this.nextAllocPageOffset = arrayInputStream.readLong();
        this.reserved1 = arrayInputStream.readLong();
        this.reserved2 = arrayInputStream.readLong();
        this.reserved3 = arrayInputStream.readLong();
        this.reserved4 = arrayInputStream.readLong();
    }

    private void updateAllocPageHeader() throws IOException {
        this.rawDataOut.setPosition(60);
        this.logicalDataOut.writeLong(this.nextAllocPageNumber);
        this.logicalDataOut.writeLong(this.nextAllocPageOffset);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
    }

    private AllocExtent readExtent(int n) throws IOException, ClassNotFoundException {
        ArrayInputStream arrayInputStream = this.rawDataIn;
        this.rawDataIn.setPosition(n);
        AllocExtent allocExtent = new AllocExtent();
        allocExtent.readExternal(arrayInputStream);
        return allocExtent;
    }

    private void writeExtent(int n) throws IOException {
        this.rawDataOut.setPosition(n);
        this.extent.writeExternal(this.logicalDataOut);
    }

    public static void WriteContainerInfo(byte[] byArray, byte[] byArray2, boolean bl) throws StandardException {
        int n;
        int n2 = n = byArray == null ? 0 : byArray.length;
        if (n + 1 + 108 > byArray2.length) {
            // empty if block
        }
        if (bl) {
            byArray2[108] = (byte)n;
        } else {
            byte by = byArray2[108];
            if (by != n) {
                throw StandardException.newException("XSDB3.D", new Long(by), (Object)new Long(n));
            }
        }
        if (n != 0) {
            System.arraycopy(byArray, 0, byArray2, 109, n);
        }
    }

    public static void ReadContainerInfo(byte[] byArray, byte[] byArray2) {
        byte by = byArray2[108];
        if (by != 0) {
            System.arraycopy(byArray2, 109, byArray, 0, by);
        }
    }

    public long nextFreePageNumber(long l) {
        return this.extent.getFreePageNumber(l);
    }

    public void addPage(FileContainer fileContainer, long l, RawTransaction rawTransaction, BaseContainerHandle baseContainerHandle) throws StandardException {
        this.owner.getAllocationActionSet().actionAllocatePage(rawTransaction, this, l, 0, 2);
    }

    public void deallocatePage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        this.owner.getAllocationActionSet().actionAllocatePage(baseContainerHandle.getTransaction(), this, l, 1, 0);
    }

    protected void updateUnfilledPageInfo(AllocExtent allocExtent) {
        this.extent.updateUnfilledPageInfo(allocExtent);
    }

    public boolean canAddFreePage(long l) {
        if (this.extent.isRetired()) {
            return false;
        }
        if (l != -1L && this.extent.getLastPagenum() <= l && !this.isLast()) {
            return false;
        }
        return this.extent.canAddFreePage(l);
    }

    public long getNextAllocPageOffset() {
        return this.nextAllocPageOffset;
    }

    public void chainNewAllocPage(BaseContainerHandle baseContainerHandle, long l, long l2) throws StandardException {
        this.owner.getAllocationActionSet().actionChainAllocPage(baseContainerHandle.getTransaction(), this, l, l2);
    }

    public long getNextAllocPageNumber() {
        return this.nextAllocPageNumber;
    }

    public boolean isLast() {
        return this.nextAllocPageNumber == -1L;
    }

    public long getLastPagenum() {
        return this.extent.getLastPagenum();
    }

    public long getMaxPagenum() {
        return this.extent.getExtentEnd();
    }

    protected long getLastPreallocPagenum() {
        return this.extent.getLastPreallocPagenum();
    }

    protected int getPageStatus(long l) {
        return this.extent.getPageStatus(l);
    }

    protected void setPageStatus(LogInstant logInstant, long l, int n) throws StandardException {
        this.logAction(logInstant);
        switch (n) {
            case 0: {
                this.extent.allocPage(l);
                break;
            }
            case 1: {
                this.extent.deallocPage(l);
                break;
            }
            case 2: {
                this.extent.deallocPage(l);
                break;
            }
        }
    }

    protected void chainNextAllocPage(LogInstant logInstant, long l, long l2) throws StandardException {
        this.logAction(logInstant);
        this.nextAllocPageNumber = l;
        this.nextAllocPageOffset = l2;
    }

    public String toString() {
        return null;
    }

    protected AllocExtent getAllocExtent() {
        return this.extent;
    }

    protected void preAllocatePage(FileContainer fileContainer, int n, int n2) {
        long l = this.extent.getLastPreallocPagenum();
        if (l < (long)n) {
            return;
        }
        if (this.extent.getExtentEnd() < l + (long)n2) {
            n2 = (int)(this.extent.getExtentEnd() - l);
        }
        if (n2 <= 0) {
            return;
        }
        int n3 = fileContainer.preAllocate(l, n2);
        if (n3 > 0) {
            this.extent.setLastPreallocPagenum(l + (long)n3);
        }
    }
}

