/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.ByteHolderInputStream;

public class RememberBytesInputStream
extends FilterInputStream {
    ByteHolder bh;
    boolean recording = true;

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.bh.write(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 + n > byArray.length) {
            n2 = byArray.length - n;
        }
        if ((n2 = super.read(byArray, n, n2)) != -1) {
            this.bh.write(byArray, n, n2);
        }
        return n2;
    }

    public long fillBuf(int n) throws IOException {
        return this.bh.write(this.in, n);
    }

    public int putBuf(OutputStream outputStream, int n) throws IOException {
        this.bh.startReading();
        return this.bh.read(outputStream, n);
    }

    public long skip(long l) throws IOException {
        return this.bh.write(this.in, l);
    }

    public InputStream getReplayStream() throws IOException {
        this.bh.startReading();
        this.recording = false;
        return new ByteHolderInputStream(this.bh);
    }

    public ByteHolder getByteHolder() throws IOException {
        return this.bh;
    }

    public void clear() throws IOException {
        this.bh.clear();
        this.recording = true;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean recording() {
        return this.recording;
    }

    public int available() throws IOException {
        int n = this.bh.available();
        n = n > 0 ? n : -1 * n;
        return n;
    }

    public int numBytesSaved() throws IOException {
        return this.bh.numBytesSaved();
    }

    public int shiftToFront() throws IOException {
        int n = this.bh.shiftToFront();
        return n;
    }

    public String toString() {
        return "RememberBytesInputStream: " + " recording: " + this.recording + " " + this.bh;
    }

    public RememberBytesInputStream(InputStream inputStream, ByteHolder byteHolder) {
        super(inputStream);
        this.bh = byteHolder;
    }
}

