/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;

public class XactXAResourceManager
implements XAResourceManager {
    private TransactionTable transaction_table;
    private RawStoreFactory rsf;

    public void commit(ContextManager contextManager, Xid xid, boolean bl) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        if (transaction == null) {
            throw StandardException.newException("XSAX0.S");
        }
        transaction.xa_commit(bl);
    }

    public ContextManager find(Xid xid) {
        return this.transaction_table.findTransactionContextByGlobalId(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
    }

    public void forget(ContextManager contextManager, Xid xid) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        throw StandardException.newException("XSAX0.S");
    }

    public Xid[] recover(int n) throws StandardException {
        Xid[] xidArray;
        if ((n & 0x1000000) != 0) {
            int n2;
            Hashtable hashtable = this.transaction_table.getTableForXA();
            XAXactId[] xAXactIdArray = new XAXactId[hashtable.size()];
            int n3 = 0;
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                n2 = 0;
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    Xact xact = ((TransactionTableEntry)enumeration.nextElement()).getXact();
                    if (xact.isPrepared()) {
                        GlobalTransactionId globalTransactionId = xact.getGlobalId();
                        xAXactIdArray[n2] = new XAXactId(globalTransactionId.getFormat_Id(), globalTransactionId.getGlobalTransactionId(), globalTransactionId.getBranchQualifier());
                        ++n3;
                    }
                    ++n2;
                }
            }
            xidArray = new XAXactId[n3];
            n2 = 0;
            int n4 = xAXactIdArray.length;
            while (n4-- > 0) {
                if (xAXactIdArray[n4] == null) continue;
                xidArray[n2++] = xAXactIdArray[n4];
            }
        } else {
            xidArray = new XAXactId[]{};
        }
        return xidArray;
    }

    public void rollback(ContextManager contextManager, Xid xid) throws StandardException {
        Transaction transaction = this.rsf.findUserTransaction(contextManager, "UserTransaction");
        if (transaction == null) {
            throw StandardException.newException("XSAX0.S");
        }
        transaction.xa_rollback();
    }

    public XactXAResourceManager(RawStoreFactory rawStoreFactory, TransactionTable transactionTable) {
        this.rsf = rawStoreFactory;
        this.transaction_table = transactionTable;
    }
}

