/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.jmx;

import java.util.HashMap;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpContext;
import org.mortbay.http.RequestLog;
import org.mortbay.util.LifeCycleEvent;
import org.mortbay.util.LifeCycleListener;
import org.mortbay.util.jmx.LifeCycleMBean;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class HttpContextMBean
extends LifeCycleMBean {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$jmx$HttpContextMBean == null ? (class$org$mortbay$http$jmx$HttpContextMBean = HttpContextMBean.class$("org.mortbay.http.jmx.HttpContextMBean")) : class$org$mortbay$http$jmx$HttpContextMBean);
    private HttpContext _httpContext;
    private HashMap _rlMap = new HashMap(3);
    private HashMap _handlerMap = new HashMap();
    static /* synthetic */ Class class$org$mortbay$http$jmx$HttpContextMBean;

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("virtualHosts");
        this.defineAttribute("hosts");
        this.defineAttribute("contextPath");
        this.defineAttribute("handlers", false, true);
        this.defineAttribute("requestLog", false, true);
        this.defineAttribute("classPath");
        this.defineAttribute("realm");
        this.defineAttribute("realmName");
        this.defineAttribute("redirectNullPath");
        this.defineAttribute("resourceBase");
        this.defineAttribute("maxCachedFileSize");
        this.defineAttribute("maxCacheSize");
        this.defineOperation("flushCache", 1);
        this.defineOperation("getResource", new String[]{"java.lang.String"}, 1);
        this.defineAttribute("welcomeFiles");
        this.defineOperation("addWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineOperation("removeWelcomeFile", new String[]{"java.lang.String"}, 0);
        this.defineAttribute("mimeMap");
        this.defineOperation("setMimeMapping", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineAttribute("statsOn");
        this.defineAttribute("statsOnMs");
        this.defineOperation("statsReset", 1);
        this.defineAttribute("requests");
        this.defineAttribute("requestsActive");
        this.defineAttribute("requestsActiveMax");
        this.defineAttribute("responses1xx");
        this.defineAttribute("responses2xx");
        this.defineAttribute("responses3xx");
        this.defineAttribute("responses4xx");
        this.defineAttribute("responses5xx");
        this.defineOperation("stop", new String[]{"java.lang.Boolean.TYPE"}, 1);
        this.defineOperation("destroy", 1);
        this.defineOperation("setInitParameter", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("getInitParameter", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getInitParameterNames", ModelMBeanImpl.NO_PARAMS, 0);
        this.defineOperation("setAttribute", new String[]{"java.lang.String", "java.lang.Object"}, 1);
        this.defineOperation("getAttribute", new String[]{"java.lang.String"}, 0);
        this.defineOperation("getAttributeNames", ModelMBeanImpl.NO_PARAMS, 0);
        this.defineOperation("removeAttribute", new String[]{"java.lang.String"}, 1);
        this.defineOperation("addHandler", new String[]{"org.mortbay.http.HttpHandler"}, 1);
        this.defineOperation("addHandler", new String[]{"int", "org.mortbay.http.HttpHandler"}, 1);
        this.defineOperation("removeHandler", new String[]{"int"}, 1);
        this._httpContext = (HttpContext)this.getManagedResource();
        this._httpContext.addEventListener(new LifeCycleListener(){

            public void lifeCycleStarting(LifeCycleEvent event) {
            }

            public void lifeCycleStarted(LifeCycleEvent event) {
                HttpContextMBean.this.getHandlers();
            }

            public void lifeCycleFailure(LifeCycleEvent event) {
            }

            public void lifeCycleStopping(LifeCycleEvent event) {
            }

            public void lifeCycleStopped(LifeCycleEvent event) {
                HttpContextMBean.this.destroyHandlers();
            }
        });
    }

    protected ObjectName newObjectName(MBeanServer server) {
        ObjectName oName = super.newObjectName(server);
        String context = this._httpContext.getContextPath();
        if (context.length() == 0) {
            context = "/";
        }
        try {
            oName = new ObjectName(oName + ",context=" + context);
        }
        catch (Exception e) {
            log.warn("EXCEPTION ", e);
        }
        return oName;
    }

    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue()) {
            this.getHandlers();
        }
    }

    public void postDeregister() {
        this._httpContext = null;
        this.destroyComponentMBeans(this._handlerMap);
        super.postDeregister();
    }

    public ObjectName[] getHandlers() {
        return this.getComponentMBeans(this._httpContext.getHandlers(), this._handlerMap);
    }

    public void destroyHandlers() {
        this.destroyComponentMBeans(this._handlerMap);
    }

    public ObjectName getRequestLog() {
        RequestLog o = this._httpContext.getRequestLog();
        if (o == null) {
            return null;
        }
        ObjectName[] on = this.getComponentMBeans(new Object[]{o}, this._rlMap);
        if (on.length > 0) {
            return on[0];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

