/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.LazyList;

public class ByteBufferInputStream
extends InputStream {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$nio$ByteBufferInputStream == null ? (class$org$mortbay$http$nio$ByteBufferInputStream = ByteBufferInputStream.class$("org.mortbay.http.nio.ByteBufferInputStream")) : class$org$mortbay$http$nio$ByteBufferInputStream);
    long _timeout = 30000L;
    int _bufferSize;
    ByteBuffer _buffer;
    Object _buffers;
    Object _recycle;
    boolean _closed = false;
    static /* synthetic */ Class class$org$mortbay$http$nio$ByteBufferInputStream;

    public ByteBufferInputStream(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long l) {
        this._timeout = l;
    }

    public synchronized int read() throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        return this._buffer.get();
    }

    public synchronized int available() throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        return this._buffer.remaining();
    }

    public synchronized void close() throws IOException {
        this._closed = true;
        this.notify();
    }

    public synchronized void mark(int arg0) {
    }

    public synchronized boolean markSupported() {
        return false;
    }

    public synchronized int read(byte[] buf, int offset, int length) throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        if (length > this._buffer.remaining()) {
            length = this._buffer.remaining();
        }
        this._buffer.get(buf, offset, length);
        return length;
    }

    public synchronized int read(byte[] buf) throws IOException {
        if (!this.waitForContent()) {
            return -1;
        }
        int length = buf.length;
        if (length > this._buffer.remaining()) {
            length = this._buffer.remaining();
        }
        this._buffer.get(buf, 0, length);
        return length;
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public long skip(long length) throws IOException {
        if (!this.waitForContent()) {
            return -1L;
        }
        if (length > (long)this._buffer.remaining()) {
            length = this._buffer.remaining();
        }
        this._buffer.position((int)((long)this._buffer.position() + length));
        return length;
    }

    public synchronized void write(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            this._buffers = LazyList.add(this._buffers, buffer);
            this.notify();
        } else {
            this.recycle(buffer);
        }
    }

    private synchronized boolean waitForContent() throws InterruptedIOException {
        if (this._buffer != null) {
            if (this._buffer.hasRemaining()) {
                return true;
            }
            this.recycle(this._buffer);
            this._buffer = null;
        }
        while (!this._closed && LazyList.size(this._buffers) == 0) {
            try {
                this.wait(this._timeout);
            }
            catch (InterruptedException e) {
                log.debug(e);
                throw new InterruptedIOException(e.toString());
            }
        }
        if (this._closed) {
            return false;
        }
        if (LazyList.size(this._buffers) == 0) {
            throw new SocketTimeoutException();
        }
        this._buffer = (ByteBuffer)LazyList.get(this._buffers, 0);
        this._buffers = LazyList.remove(this._buffers, 0);
        return true;
    }

    public synchronized ByteBuffer getBuffer() {
        ByteBuffer buf = null;
        int s = LazyList.size(this._recycle);
        if (s > 0) {
            buf = (ByteBuffer)LazyList.get(this._recycle, --s);
            this._recycle = LazyList.remove(this._recycle, s);
            buf.clear();
        } else {
            buf = ByteBuffer.allocateDirect(this._bufferSize);
        }
        return buf;
    }

    public synchronized void recycle(ByteBuffer buf) {
        this._recycle = LazyList.add(this._recycle, buf);
    }

    public void destroy() {
        this._buffer = null;
        this._buffers = null;
        this._recycle = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

