/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object pauseLock = new Object();
    private Object idleLock = new Object();
    private boolean signaled;
    private boolean paused;
    private boolean halted;
    private SchedulingContext ctxt = null;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private long dbFailureRetryInterval = 15000L;
    static /* synthetic */ Class class$org$quartz$core$QuartzSchedulerThread;

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, false, 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), qsRsrcs.getThreadName());
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = false;
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
        this.idleWaitVariablness = (int)((double)waitTime * 0.2);
    }

    private long getDbFailureRetryInterval() {
        return this.dbFailureRetryInterval;
    }

    public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
        this.dbFailureRetryInterval = dbFailureRetryInterval;
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    void togglePause(boolean pause) {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange();
            } else {
                this.pauseLock.notify();
            }
        }
    }

    void halt() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.halted = true;
            if (this.paused) {
                this.pauseLock.notify();
            } else {
                this.signalSchedulingChange();
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    void signalSchedulingChange() {
        this.signaled = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        lastAcquireFailed = false;
        while (!this.halted) {
            block34: {
                block35: {
                    var2_2 = this.pauseLock;
                    synchronized (var2_2) {
                        while (this.paused && !this.halted) {
                            try {
                                this.pauseLock.wait(100L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        if (this.halted) {
                            break;
                        }
                    }
                    trigger = null;
                    idleWait = true;
                    try {
                        trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt);
                        lastAcquireFailed = false;
                    }
                    catch (JobPersistenceException jpe) {
                        if (!lastAcquireFailed) {
                            this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
                        }
                        lastAcquireFailed = true;
                    }
                    catch (RuntimeException e) {
                        if (!lastAcquireFailed) {
                            QuartzSchedulerThread.getLog().error("quartzSchedulerThreadLoop: RuntimeException " + e.getMessage(), e);
                        }
                        lastAcquireFailed = true;
                    }
                    if (trigger == null) break block34;
                    now = System.currentTimeMillis();
                    triggerTime = trigger.getNextFireTime().getTime();
                    timeUntilTrigger = triggerTime - now;
                    spinInterval = 10L;
                    if (timeUntilTrigger > this.idleWaitTime) break block35;
                    numPauses = (int)(timeUntilTrigger / spinInterval);
                    if (true) ** GOTO lbl59
                }
                try {
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                }
                catch (JobPersistenceException jpe) {
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                    this.releaseTriggerRetryLoop(trigger);
                }
                catch (RuntimeException e) {
                    QuartzSchedulerThread.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
                    this.releaseTriggerRetryLoop(trigger);
                }
                idleWait = true;
                break block34;
                do {
                    try {
                        Thread.sleep(spinInterval);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                    timeUntilTrigger = triggerTime - now;
                    numPauses = (int)(timeUntilTrigger / spinInterval);
lbl59:
                    // 2 sources

                } while (numPauses >= 0 && !this.signaled);
                if (this.signaled) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    catch (RuntimeException e) {
                        QuartzSchedulerThread.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    this.signaled = false;
                    continue;
                }
                bndle = null;
                try {
                    bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
                }
                catch (SchedulerException se) {
                    this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
                }
                if (bndle == null) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (SchedulerException se) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    continue;
                }
                shell = null;
                try {
                    shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
                    shell.initialize(this.qs, bndle);
                }
                catch (SchedulerException se) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (SchedulerException se2) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se2);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    continue;
                }
                this.qsRsrcs.getThreadPool().runInThread(shell);
                idleWait = false;
            }
            now = System.currentTimeMillis();
            waitTime = now + this.getRandomizedIdleWaitTime();
            timeUntilContinue = waitTime - now;
            spinInterval = 10L;
            numPauses = (int)(timeUntilContinue / spinInterval);
            while (idleWait && numPauses > 0 && !this.signaled) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                timeUntilContinue = waitTime - now;
                numPauses = (int)(timeUntilContinue / spinInterval);
            }
            this.signaled = false;
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseTriggerRetryLoop(Trigger trigger) {
        int retryCount = 0;
        try {
            while (true) {
                if (this.halted) {
                    break;
                }
                try {
                    Thread.sleep(this.getDbFailureRetryInterval());
                    ++retryCount;
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    retryCount = 0;
                }
                catch (JobPersistenceException jpe) {
                    if (retryCount % 4 != 0) continue;
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                    continue;
                }
                catch (RuntimeException e) {
                    QuartzSchedulerThread.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), e);
                    continue;
                }
                catch (InterruptedException e) {
                    QuartzSchedulerThread.getLog().error("releaseTriggerRetryLoop: InterruptedException " + e.getMessage(), e);
                    continue;
                }
                break;
            }
            Object var7_6 = null;
            if (retryCount != 0) return;
            QuartzSchedulerThread.getLog().info("releaseTriggerRetryLoop: connection restored.");
            return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (retryCount != 0) throw throwable;
            QuartzSchedulerThread.getLog().info("releaseTriggerRetryLoop: connection restored.");
            throw throwable;
        }
    }

    public static Log getLog() {
        return LogFactory.getLog(class$org$quartz$core$QuartzSchedulerThread == null ? (class$org$quartz$core$QuartzSchedulerThread = QuartzSchedulerThread.class$("org.quartz.core.QuartzSchedulerThread")) : class$org$quartz$core$QuartzSchedulerThread);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

