/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerServlet
extends HttpServlet {
    private boolean performShutdown = true;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        this.log("Quartz Initializer Servlet loaded, initializing Scheduler...");
        try {
            String configFile = cfg.getInitParameter("config-file");
            String shutdownPref = cfg.getInitParameter("shutdown-on-unload");
            if (shutdownPref != null) {
                this.performShutdown = Boolean.getBoolean(shutdownPref);
            }
            StdSchedulerFactory factory = configFile != null ? new StdSchedulerFactory(configFile) : new StdSchedulerFactory();
            Scheduler scheduler = factory.getScheduler();
            scheduler.start();
        }
        catch (Exception e) {
            this.log("Quartz Scheduler failed to initialize: " + e.toString());
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (!this.performShutdown) {
            return;
        }
        try {
            Scheduler sched = StdSchedulerFactory.getDefaultScheduler();
            if (sched != null) {
                sched.shutdown();
            }
        }
        catch (Exception e) {
            this.log("Quartz Scheduler failed to shutdown cleanly: " + e.toString());
            e.printStackTrace();
        }
        this.log("Quartz Scheduler successful shutdown.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(403);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(403);
    }
}

