/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.StdJDBCConstants;
import org.quartz.impl.jdbcjobstore.Util;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public class StdJDBCDelegate
implements DriverDelegate,
StdJDBCConstants {
    protected Log logger = null;
    protected String tablePrefix = "QRTZ_";
    protected String instanceId;
    protected boolean useProperties;

    public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId) {
        this.logger = logger;
        this.tablePrefix = tablePrefix;
        this.instanceId = instanceId;
    }

    public StdJDBCDelegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties) {
        this.logger = logger;
        this.tablePrefix = tablePrefix;
        this.instanceId = instanceId;
        this.useProperties = useProperties;
    }

    protected boolean canUseProperties() {
        return this.useProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStatesFromOtherStates(Connection conn, String newState, String oldState1, String oldState2) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_STATE = ? OR TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, oldState1);
            ps.setString(3, oldState2);
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectMisfiredTriggers(Connection conn, long ts) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ?"));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("TRIGGER_NAME");
                    String groupName = rs.getString("TRIGGER_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var11_9 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectTriggersInState(Connection conn, String state) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                Key[] sArr;
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ?"));
                ps.setString(1, state);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    list.add(new Key(rs.getString(1), rs.getString(2)));
                }
                keyArray = sArr = list.toArray(new Key[list.size()]);
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectMisfiredTriggersInState(Connection conn, String state, long ts) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_STATE = ?"));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                ps.setString(2, state);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("TRIGGER_NAME");
                    String groupName = rs.getString("TRIGGER_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var12_10 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var12_11 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectMisfiredTriggersInGroupInState(Connection conn, String groupName, String state, long ts) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE NEXT_FIRE_TIME < ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
                ps.setBigDecimal(1, new BigDecimal(String.valueOf(ts)));
                ps.setString(2, groupName);
                ps.setString(3, state);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("TRIGGER_NAME");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var13_11 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var13_12 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException {
        SQLException ignore22;
        Trigger[] triggerArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
                ps.setString(1, this.instanceId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                long dumId = System.currentTimeMillis();
                ArrayList<SimpleTrigger> list = new ArrayList<SimpleTrigger>();
                while (rs.next()) {
                    String jobName = rs.getString("JOB_NAME");
                    String jobGroup = rs.getString("JOB_GROUP");
                    long firedTime = rs.getLong("FIRED_TIME");
                    SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
                    rcvryTrig.setJobName(jobName);
                    rcvryTrig.setJobGroup(jobGroup);
                    rcvryTrig.setMisfireInstruction(1);
                    list.add(rcvryTrig);
                }
                Object[] oArr = list.toArray();
                Trigger[] tArr = new Trigger[oArr.length];
                System.arraycopy(oArr, 0, tArr, 0, oArr.length);
                triggerArray = tArr;
                Object var13_11 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var13_12 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return triggerArray;
        try {
            ps.close();
            return triggerArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return triggerArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteFiredTriggers(Connection conn) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS"));
            n = ps.executeUpdate();
            Object var5_4 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteFiredTriggers(Connection conn, String instanceId) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
            ps.setString(1, instanceId);
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block7: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, job.getName());
                ps.setString(2, job.getGroup());
                ps.setString(3, job.getDescription());
                ps.setString(4, job.getJobClass().getName());
                ps.setBoolean(5, job.isDurable());
                ps.setBoolean(6, job.isVolatile());
                ps.setBoolean(7, job.isStateful());
                ps.setBoolean(8, job.requestsRecovery());
                ps.setBytes(9, baos.toByteArray());
                insertResult = ps.executeUpdate();
                Object var7_6 = null;
                if (null == ps) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) {
                return insertResult;
            }
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
        int insertResult;
        block7: {
            ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, job.getDescription());
                ps.setString(2, job.getJobClass().getName());
                ps.setBoolean(3, job.isDurable());
                ps.setBoolean(4, job.isVolatile());
                ps.setBoolean(5, job.isStateful());
                ps.setBoolean(6, job.requestsRecovery());
                ps.setBytes(7, baos.toByteArray());
                ps.setString(8, job.getName());
                ps.setString(9, job.getGroup());
                insertResult = ps.executeUpdate();
                Object var7_6 = null;
                if (null == ps) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteJobListeners(conn, job.getName(), job.getGroup());
        String[] jobListeners = job.getJobListenerNames();
        int i = 0;
        while (jobListeners != null) {
            if (i >= jobListeners.length) {
                return insertResult;
            }
            this.insertJobListener(conn, job, jobListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectTriggerNamesForJob(Connection conn, String jobName, String groupName) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>(10);
                while (rs.next()) {
                    String trigName = rs.getString("TRIGGER_NAME");
                    String trigGroup = rs.getString("TRIGGER_GROUP");
                    list.add(new Key(trigName, trigGroup));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var11_10 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_11 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteJobDetail(Connection conn, String jobName, String groupName) throws SQLException {
        int n;
        Statement ps = null;
        try {
            this.logger.debug("Deleting job: " + groupName + "." + jobName);
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isJobStateful(Connection conn, String jobName, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT IS_STATEFUL FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (rs.next()) break block14;
            var6_6 = false;
            var8_8 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_6;
            }
            var6_7 = rs.getBoolean("IS_STATEFUL");
        }
        var8_9 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var6_7;
        catch (Throwable var7_14) {
            block15: {
                var8_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_14;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean jobExists(Connection conn, String jobName, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var6_6 = true;
            var8_8 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_6;
            }
            var6_7 = false;
        }
        var8_9 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var6_7;
        catch (Throwable var7_14) {
            block15: {
                var8_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_14;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeJobData(job.getJobDataMap());
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setBytes(1, baos.toByteArray());
            ps.setString(2, job.getName());
            ps.setString(3, job.getGroup());
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertJobListener(Connection conn, JobDetail job, String listener) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}JOB_LISTENERS (JOB_NAME, JOB_GROUP, JOB_LISTENER) VALUES(?, ?, ?)"));
            ps.setString(1, job.getName());
            ps.setString(2, job.getGroup());
            ps.setString(3, listener);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectJobListeners(Connection conn, String jobName, String groupName) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ArrayList<String> list = new ArrayList<String>();
                ps = conn.prepareStatement(this.rtp("SELECT JOB_LISTENER FROM {0}JOB_LISTENERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var11_10 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_11 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobDetail selectJobDetail(Connection conn, String jobName, String groupName, ClassLoadHelper loadHelper) throws ClassNotFoundException, IOException, SQLException {
        SQLException ignore22;
        JobDetail jobDetail;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}JOB_DETAILS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                JobDetail job = null;
                if (rs.next()) {
                    job = new JobDetail();
                    job.setName(rs.getString("JOB_NAME"));
                    job.setGroup(rs.getString("JOB_GROUP"));
                    job.setDescription(rs.getString("DESCRIPTION"));
                    job.setJobClass(loadHelper.loadClass(rs.getString("JOB_CLASS_NAME")));
                    job.setDurability(rs.getBoolean("IS_DURABLE"));
                    job.setVolatility(rs.getBoolean("IS_VOLATILE"));
                    job.setRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                    Map map = null;
                    map = this.canUseProperties() ? this.getMapFromProperties(rs) : (Map)this.getObjectFromBlob(rs, "JOB_DATA");
                    if (null != map) {
                        job.setJobDataMap(new JobDataMap(map));
                    }
                }
                jobDetail = job;
                Object var10_9 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var10_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return jobDetail;
        try {
            ps.close();
            return jobDetail;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return jobDetail;
    }

    private Map getMapFromProperties(ResultSet rs) throws ClassNotFoundException, IOException, SQLException {
        InputStream is = (InputStream)this.getJobDetailFromBlob(rs, "JOB_DATA");
        Properties properties = new Properties();
        if (is != null) {
            properties.load(is);
        }
        Map map = this.convertFromProperty(properties);
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int selectNumJobs(Connection conn) throws SQLException {
        SQLException ignore22;
        int n;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                int count = 0;
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(JOB_NAME)  FROM {0}JOB_DETAILS"));
                rs = ps.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                n = count;
                Object var7_6 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return n;
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectJobGroups(Connection conn) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT DISTINCT(JOB_GROUP) FROM {0}JOB_DETAILS"));
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectJobsInGroup(Connection conn, String groupName) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME FROM {0}JOB_DETAILS WHERE JOB_GROUP = ?"));
                ps.setString(1, groupName);
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var10_9 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var10_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block13: {
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
                ps.setString(1, trigger.getName());
                ps.setString(2, trigger.getGroup());
                ps.setString(3, trigger.getJobName());
                ps.setString(4, trigger.getJobGroup());
                ps.setBoolean(5, trigger.isVolatile());
                ps.setString(6, trigger.getDescription());
                ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(9, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(10, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(10, "CRON");
                } else {
                    ps.setString(10, "BLOB");
                }
                ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
                ps.setString(13, trigger.getCalendarName());
                ps.setInt(14, trigger.getMisfireInstruction());
                insertResult = ps.executeUpdate();
                Object var12_10 = null;
                if (null == ps) break block13;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) {
                return insertResult;
            }
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}SIMPLE_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, REPEAT_COUNT, REPEAT_INTERVAL, TIMES_TRIGGERED)  VALUES(?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setInt(3, trigger.getRepeatCount());
            ps.setBigDecimal(4, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
            ps.setInt(5, trigger.getTimesTriggered());
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CRON_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID)  VALUES(?, ?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, trigger.getCronExpression());
            ps.setString(4, trigger.getTimeZone().getID());
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        int n;
        Statement ps = null;
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(trigger);
            oos.close();
            byte[] buf = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}BLOB_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, BLOB_DATA)  VALUES(?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setBinaryStream(3, is, buf.length);
            n = ps.executeUpdate();
            Object var10_9 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException {
        int insertResult;
        block14: {
            PreparedStatement ps = null;
            insertResult = 0;
            try {
                ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, trigger.getJobName());
                ps.setString(2, trigger.getJobGroup());
                ps.setBoolean(3, trigger.isVolatile());
                ps.setString(4, trigger.getDescription());
                long nextFireTime = -1L;
                if (trigger.getNextFireTime() != null) {
                    nextFireTime = trigger.getNextFireTime().getTime();
                }
                ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
                long prevFireTime = -1L;
                if (trigger.getPreviousFireTime() != null) {
                    prevFireTime = trigger.getPreviousFireTime().getTime();
                }
                ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
                ps.setString(7, state);
                if (trigger instanceof SimpleTrigger) {
                    ps.setString(8, "SIMPLE");
                } else if (trigger instanceof CronTrigger) {
                    ps.setString(8, "CRON");
                } else {
                    ps.setString(8, "BLOB");
                }
                ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
                long endTime = 0L;
                if (trigger.getEndTime() != null) {
                    endTime = trigger.getEndTime().getTime();
                }
                ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
                ps.setString(11, trigger.getCalendarName());
                ps.setInt(12, trigger.getMisfireInstruction());
                ps.setString(13, trigger.getName());
                ps.setString(14, trigger.getGroup());
                insertResult = ps.executeUpdate();
                Object var14_11 = null;
                if (null == ps) break block14;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignore) {}
            ps.close();
        }
        if (insertResult <= 0) return insertResult;
        this.deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
        String[] trigListeners = trigger.getTriggerListenerNames();
        int i = 0;
        while (trigListeners != null) {
            if (i >= trigListeners.length) {
                return insertResult;
            }
            this.insertTriggerListener(conn, trigger, trigListeners[i]);
            ++i;
        }
        return insertResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateSimpleTrigger(Connection conn, SimpleTrigger trigger) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}SIMPLE_TRIGGERS SET REPEAT_COUNT = ?, REPEAT_INTERVAL = ?, TIMES_TRIGGERED = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setInt(1, trigger.getRepeatCount());
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(trigger.getRepeatInterval())));
            ps.setInt(3, trigger.getTimesTriggered());
            ps.setString(4, trigger.getName());
            ps.setString(5, trigger.getGroup());
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateCronTrigger(Connection conn, CronTrigger trigger) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CRON_TRIGGERS SET CRON_EXPRESSION = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, trigger.getCronExpression());
            ps.setString(2, trigger.getName());
            ps.setString(3, trigger.getGroup());
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateBlobTrigger(Connection conn, Trigger trigger) throws SQLException, IOException {
        int n;
        ByteArrayOutputStream os;
        block6: {
            Statement ps = null;
            os = null;
            try {
                os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(trigger);
                oos.close();
                byte[] buf = os.toByteArray();
                ByteArrayInputStream is = new ByteArrayInputStream(buf);
                ps = conn.prepareStatement(this.rtp("UPDATE {0}BLOB_TRIGGERS SET BLOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setBinaryStream(1, is, buf.length);
                ps.setString(2, trigger.getName());
                ps.setString(3, trigger.getGroup());
                n = ps.executeUpdate();
                Object var10_9 = null;
                if (null == ps) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            try {
                ps.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (os == null) return n;
        os.close();
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public boolean triggerExists(Connection conn, String triggerName, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var6_6 = true;
            var8_8 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_6;
            }
            var6_7 = false;
        }
        var8_9 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var6_7;
        catch (Throwable var7_14) {
            block15: {
                var8_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_14;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerState(Connection conn, String triggerName, String groupName, String state) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, state);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStateFromOtherStates(Connection conn, String triggerName, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            ps.setString(1, newState);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            ps.setString(4, oldState1);
            ps.setString(5, oldState2);
            ps.setString(6, oldState3);
            n = ps.executeUpdate();
            Object var11_10 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStateFromOtherStatesBeforeTime(Connection conn, String newState, String oldState1, String oldState2, long time) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE (TRIGGER_STATE = ? OR TRIGGER_STATE = ?) AND NEXT_FIRE_TIME < ?"));
            ps.setString(1, newState);
            ps.setString(2, oldState1);
            ps.setString(3, oldState2);
            ps.setLong(4, time);
            n = ps.executeUpdate();
            Object var10_8 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerGroupStateFromOtherStates(Connection conn, String groupName, String newState, String oldState1, String oldState2, String oldState3) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND (TRIGGER_STATE = ? OR TRIGGER_STATE = ? OR TRIGGER_STATE = ?)"));
            ps.setString(1, newState);
            ps.setString(2, groupName);
            ps.setString(3, oldState1);
            ps.setString(4, oldState2);
            ps.setString(5, oldState3);
            n = ps.executeUpdate();
            Object var10_9 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStateFromOtherState(Connection conn, String triggerName, String groupName, String newState, String oldState) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, triggerName);
            ps.setString(3, groupName);
            ps.setString(4, oldState);
            n = ps.executeUpdate();
            Object var9_8 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerGroupStateFromOtherState(Connection conn, String groupName, String newState, String oldState) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE TRIGGER_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, newState);
            ps.setString(2, groupName);
            ps.setString(3, oldState);
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStatesForJob(Connection conn, String jobName, String groupName, String state) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, state);
            ps.setString(2, jobName);
            ps.setString(3, groupName);
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateTriggerStatesForJobFromOtherState(Connection conn, String jobName, String groupName, String state, String oldState) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}TRIGGERS SET TRIGGER_STATE = ? WHERE JOB_NAME = ? AND JOB_GROUP = ? AND TRIGGER_STATE = ?"));
            ps.setString(1, state);
            ps.setString(2, jobName);
            ps.setString(3, groupName);
            ps.setString(4, oldState);
            n = ps.executeUpdate();
            Object var9_8 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertTriggerListener(Connection conn, Trigger trigger, String listener) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}TRIGGER_LISTENERS (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER) VALUES(?, ?, ?)"));
            ps.setString(1, trigger.getName());
            ps.setString(2, trigger.getGroup());
            ps.setString(3, listener);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectTriggerListeners(Connection conn, String triggerName, String groupName) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_LISTENER FROM {0}TRIGGER_LISTENERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var11_10 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var11_11 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteSimpleTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteCronTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteBlobTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            n = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int selectNumTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var6_6 = rs.getInt(1);
            var8_8 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_6;
            }
            var6_7 = 0;
        }
        var8_9 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var6_7;
        catch (Throwable var7_14) {
            block15: {
                var8_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_14;
        }
    }

    /*
     * Unable to fully structure code
     */
    public JobDetail selectJobForTrigger(Connection conn, String triggerName, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT J.JOB_NAME, J.JOB_GROUP, J.IS_DURABLE, J.IS_STATEFUL FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_NAME = ? AND T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP"));
            ps.setString(1, triggerName);
            ps.setString(2, groupName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            job = new JobDetail();
            job.setName(rs.getString(1));
            job.setGroup(rs.getString(2));
            job.setDurability(rs.getBoolean(3));
            job.setRequestsRecovery(rs.getBoolean(4));
            var7_8 = job;
            var9_9 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var7_8;
            }
            this.logger.debug("No job for trigger '" + groupName + "." + triggerName + "'.");
            var6_7 = null;
        }
        var9_10 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl49
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl49:
        // 3 sources

        return var6_7;
        catch (Throwable var8_15) {
            block15: {
                var9_11 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var8_15;
        }
    }

    public Trigger[] selectTriggersForJob(Connection conn, String jobName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        SQLException ignore22;
        PreparedStatement ps;
        ArrayList<Trigger> trigList;
        block12: {
            trigList = new ArrayList<Trigger>();
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                ps.setString(1, jobName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    trigList.add(this.selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                }
                Object var8_7 = null;
                if (null == rs) break block12;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var8_8 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {}
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    public Trigger[] selectTriggersForCalendar(Connection conn, String calName) throws SQLException, ClassNotFoundException, IOException {
        SQLException ignore22;
        PreparedStatement ps;
        ArrayList<Trigger> trigList;
        block12: {
            trigList = new ArrayList<Trigger>();
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
                ps.setString(1, calName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    trigList.add(this.selectTrigger(conn, rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                }
                Object var7_6 = null;
                if (null == rs) break block12;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {}
        }
        return trigList.toArray(new Trigger[trigList.size()]);
    }

    public List selectStatefulJobsOfTriggerGroup(Connection conn, String groupName) throws SQLException {
        SQLException ignore22;
        PreparedStatement ps;
        ArrayList<Key> jobList;
        block12: {
            jobList = new ArrayList<Key>();
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT DISTINCT J.JOB_NAME, J.JOB_GROUP FROM {0}TRIGGERS T, {0}JOB_DETAILS J WHERE T.TRIGGER_GROUP = ? AND T.JOB_NAME = J.JOB_NAME AND T.JOB_GROUP = J.JOB_GROUP AND J.IS_STATEFUL = ?"));
                ps.setString(1, groupName);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                while (rs.next()) {
                    jobList.add(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                }
                Object var7_6 = null;
                if (null == rs) break block12;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null != ps) {
                    try {
                        ps.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException ignore22) {}
        }
        return jobList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Trigger selectTrigger(Connection conn, String triggerName, String groupName) throws SQLException, ClassNotFoundException, IOException {
        SQLException ignore22;
        Trigger trigger;
        PreparedStatement ps;
        block24: {
            ps = null;
            ResultSet rs = null;
            try {
                Trigger trigger2 = null;
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    String jobName = rs.getString("JOB_NAME");
                    String jobGroup = rs.getString("JOB_GROUP");
                    long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
                    long prevFireTime = rs.getLong("PREV_FIRE_TIME");
                    String triggerType = rs.getString("TRIGGER_TYPE");
                    long startTime = rs.getLong("START_TIME");
                    long endTime = rs.getLong("END_TIME");
                    String calendarName = rs.getString("CALENDAR_NAME");
                    int misFireInstr = rs.getInt("MISFIRE_INSTR");
                    String description = rs.getString("DESCRIPTION");
                    boolean volatility = rs.getBoolean("IS_VOLATILE");
                    Date nft = null;
                    if (nextFireTime > 0L) {
                        nft = new Date(nextFireTime);
                    }
                    Date pft = null;
                    if (prevFireTime > 0L) {
                        pft = new Date(prevFireTime);
                    }
                    Date startTimeD = new Date(startTime);
                    Date endTimeD = null;
                    if (endTime > 0L) {
                        endTimeD = new Date(endTime);
                    }
                    rs.close();
                    ps.close();
                    if (triggerType.equals("SIMPLE")) {
                        ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SIMPLE_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                        ps.setString(1, triggerName);
                        ps.setString(2, groupName);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            int repeatCount = rs.getInt("REPEAT_COUNT");
                            long repeatInterval = rs.getLong("REPEAT_INTERVAL");
                            int timesTriggered = rs.getInt("TIMES_TRIGGERED");
                            SimpleTrigger st = new SimpleTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, repeatCount, repeatInterval);
                            st.setCalendarName(calendarName);
                            st.setMisfireInstruction(misFireInstr);
                            st.setTimesTriggered(timesTriggered);
                            st.setVolatility(volatility);
                            st.setNextFireTime(nft);
                            st.setPreviousFireTime(pft);
                            st.setDescription(description);
                            trigger2 = st;
                        }
                    } else if (triggerType.equals("CRON")) {
                        ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}CRON_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                        ps.setString(1, triggerName);
                        ps.setString(2, groupName);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            String cronExpr = rs.getString("CRON_EXPRESSION");
                            String timeZoneId = rs.getString("TIME_ZONE_ID");
                            Trigger ct = null;
                            try {
                                TimeZone timeZone = null;
                                if (timeZoneId != null) {
                                    timeZone = TimeZone.getTimeZone(timeZoneId);
                                }
                                ct = new CronTrigger(triggerName, groupName, jobName, jobGroup, startTimeD, endTimeD, cronExpr, timeZone);
                            }
                            catch (Exception neverHappens) {
                                // empty catch block
                            }
                            if (null != ct) {
                                ct.setCalendarName(calendarName);
                                ct.setMisfireInstruction(misFireInstr);
                                ct.setVolatility(volatility);
                                ((CronTrigger)ct).setNextFireTime(nft);
                                ((CronTrigger)ct).setPreviousFireTime(pft);
                                ct.setDescription(description);
                                trigger2 = ct;
                            }
                        }
                    } else {
                        if (!triggerType.equals("BLOB")) throw new ClassNotFoundException("class for trigger type '" + triggerType + "' not found.");
                        ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}BLOB_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                        ps.setString(1, triggerName);
                        ps.setString(2, groupName);
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            trigger2 = (Trigger)this.getObjectFromBlob(rs, "BLOB_DATA");
                        }
                    }
                }
                trigger = trigger2;
                Object var32_31 = null;
                if (null == rs) break block24;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var32_32 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return trigger;
        try {
            ps.close();
            return trigger;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return trigger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String selectTriggerState(Connection conn, String triggerName, String groupName) throws SQLException {
        SQLException ignore22;
        String string;
        PreparedStatement ps;
        block9: {
            ps = null;
            ResultSet rs = null;
            try {
                String state = null;
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_STATE FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                state = rs.next() ? rs.getString("TRIGGER_STATE") : "DELETED";
                string = state.intern();
                Object var9_8 = null;
                if (null == rs) break block9;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return string;
        try {
            ps.close();
            return string;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TriggerStatus selectTriggerStatus(Connection conn, String triggerName, String groupName) throws SQLException {
        SQLException ignore22;
        TriggerStatus triggerStatus;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                TriggerStatus status = null;
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_STATE, NEXT_FIRE_TIME, JOB_NAME, JOB_GROUP FROM {0}TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                ps.setString(1, triggerName);
                ps.setString(2, groupName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    String state = rs.getString("TRIGGER_STATE");
                    long nextFireTime = rs.getLong("NEXT_FIRE_TIME");
                    String jobName = rs.getString("JOB_NAME");
                    String jobGroup = rs.getString("JOB_GROUP");
                    Date nft = null;
                    if (nextFireTime > 0L) {
                        nft = new Date(nextFireTime);
                    }
                    status = new TriggerStatus(state, nft);
                    status.setKey(new Key(triggerName, groupName));
                    status.setJobKey(new Key(jobName, jobGroup));
                }
                triggerStatus = status;
                Object var14_12 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var14_13 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return triggerStatus;
        try {
            ps.close();
            return triggerStatus;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return triggerStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int selectNumTriggers(Connection conn) throws SQLException {
        SQLException ignore22;
        int n;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                int count = 0;
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS"));
                rs = ps.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                n = count;
                Object var7_6 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return n;
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectTriggerGroups(Connection conn) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT DISTINCT(TRIGGER_GROUP) FROM {0}TRIGGERS"));
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectTriggersInGroup(Connection conn, String groupName) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
                ps.setString(1, groupName);
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var10_9 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var10_10 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertPausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}PAUSED_TRIGGER_GRPS (TRIGGER_GROUP) VALUES(?)"));
            ps.setString(1, groupName);
            n = rows = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deletePausedTriggerGroup(Connection conn, String groupName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
            ps.setString(1, groupName);
            n = rows = ps.executeUpdate();
            Object var7_6 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteAllPausedTriggerGroups(Connection conn) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            int rows;
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}PAUSED_TRIGGER_GRPS"));
            n = rows = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTriggerGroupPaused(Connection conn, String groupName) throws SQLException {
        SQLException ignore22;
        boolean bl;
        PreparedStatement ps;
        block9: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS WHERE TRIGGER_GROUP = ?"));
                ps.setString(1, groupName);
                rs = ps.executeQuery();
                bl = rs.next();
                Object var7_6 = null;
                if (null == rs) break block9;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return bl;
        try {
            ps.close();
            return bl;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isExistingTriggerGroup(Connection conn, String groupName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME)  FROM {0}TRIGGERS WHERE TRIGGER_GROUP = ?"));
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            if (rs.next()) break block14;
            var5_5 = false;
            var8_6 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var5_5;
            }
            var6_12 = rs.getInt(1) > 0;
        }
        var8_7 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl42
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl42:
        // 3 sources

        return var6_12;
        catch (Throwable var7_13) {
            block15: {
                var8_8 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_13;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
            ps.setString(1, calendarName);
            ps.setBytes(2, baos.toByteArray());
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
        int n;
        ByteArrayOutputStream baos = this.serializeObject(calendar);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
            ps.setBytes(1, baos.toByteArray());
            ps.setString(2, calendarName);
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public boolean calendarExists(Connection conn, String calendarName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
            ps.setString(1, calendarName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var5_5 = true;
            var7_7 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var5_5;
            }
            var5_6 = false;
        }
        var7_8 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl42
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl42:
        // 3 sources

        return var5_6;
        catch (Throwable var6_13) {
            block15: {
                var7_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var6_13;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Calendar selectCalendar(Connection conn, String calendarName) throws ClassNotFoundException, IOException, SQLException {
        SQLException ignore22;
        Calendar calendar;
        Statement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                String selCal = this.rtp("SELECT * FROM {0}CALENDARS WHERE CALENDAR_NAME = ?");
                this.logger.debug("sql=" + selCal);
                this.logger.debug("calendarName=" + calendarName);
                ps = conn.prepareStatement(selCal);
                ps.setString(1, calendarName);
                rs = ps.executeQuery();
                Calendar cal = null;
                if (rs.next()) {
                    cal = (Calendar)this.getObjectFromBlob(rs, "CALENDAR");
                }
                if (null == cal) {
                    this.logger.warn("Couldn't find calendar with name '" + calendarName + "'.");
                }
                calendar = cal;
                Object var9_8 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return calendar;
        try {
            ps.close();
            return calendar;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return calendar;
    }

    /*
     * Unable to fully structure code
     */
    public boolean calendarIsReferenced(Connection conn, String calendarName) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}TRIGGERS WHERE CALENDAR_NAME = ?"));
            ps.setString(1, calendarName);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var5_5 = true;
            var7_7 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var5_5;
            }
            var5_6 = false;
        }
        var7_8 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl42
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl42:
        // 3 sources

        return var5_6;
        catch (Throwable var6_13) {
            block15: {
                var7_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var6_13;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteCalendar(Connection conn, String calendarName) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}CALENDARS WHERE CALENDAR_NAME = ?"));
            ps.setString(1, calendarName);
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int selectNumCalendars(Connection conn) throws SQLException {
        SQLException ignore22;
        int n;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                int count = 0;
                ps = conn.prepareStatement(this.rtp("SELECT COUNT(CALENDAR_NAME)  FROM {0}CALENDARS"));
                rs = ps.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
                n = count;
                Object var7_6 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return n;
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] selectCalendars(Connection conn) throws SQLException {
        SQLException ignore22;
        String[] stringArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT CALENDAR_NAME FROM {0}CALENDARS"));
                rs = ps.executeQuery();
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                Object[] oArr = list.toArray();
                String[] sArr = new String[oArr.length];
                System.arraycopy(oArr, 0, sArr, 0, oArr.length);
                stringArray = sArr;
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return stringArray;
        try {
            ps.close();
            return stringArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    public long selectNextFireTime(Connection conn) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT MIN(NEXT_FIRE_TIME) AS ALIAS_NXT_FR_TM FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME >= 0"));
            ps.setString(1, "WAITING");
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var4_4 = rs.getLong("ALIAS_NXT_FR_TM");
            var7_6 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var4_4;
            }
            var4_5 = 0L;
        }
        var7_7 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl42
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl42:
        // 3 sources

        return var4_5;
        catch (Throwable var6_12) {
            block15: {
                var7_8 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var6_12;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Key selectTriggerForFireTime(Connection conn, long fireTime) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE TRIGGER_STATE = ? AND NEXT_FIRE_TIME = ?"));
            ps.setString(1, "WAITING");
            ps.setBigDecimal(2, new BigDecimal(String.valueOf(fireTime)));
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var6_5 = new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP"));
            var8_7 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_5;
            }
            var6_6 = null;
        }
        var8_8 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var6_6;
        catch (Throwable var7_13) {
            block15: {
                var8_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var7_13;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
            ps.setString(1, trigger.getFireInstanceId());
            ps.setString(2, trigger.getName());
            ps.setString(3, trigger.getGroup());
            ps.setBoolean(4, trigger.isVolatile());
            ps.setString(5, this.instanceId);
            ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
            ps.setString(7, state);
            if (job != null) {
                ps.setString(8, trigger.getJobName());
                ps.setString(9, trigger.getJobGroup());
                ps.setBoolean(10, job.isStateful());
                ps.setBoolean(11, job.requestsRecovery());
            } else {
                ps.setString(8, null);
                ps.setString(9, null);
                ps.setBoolean(10, false);
                ps.setBoolean(11, false);
            }
            n = ps.executeUpdate();
            Object var8_7 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List selectFiredTriggerRecords(Connection conn, String triggerName, String groupName) throws SQLException {
        SQLException ignore22;
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement ps;
        block13: {
            ps = null;
            ResultSet rs = null;
            try {
                LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
                if (triggerName != null) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
                    ps.setString(1, triggerName);
                    ps.setString(2, groupName);
                } else {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE TRIGGER_GROUP = ?"));
                    ps.setString(1, groupName);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    FiredTriggerRecord rec = new FiredTriggerRecord();
                    rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                    rec.setFireInstanceState(rs.getString("STATE"));
                    rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                    rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                    rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
                    rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                    if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                        rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
                        rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                        rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                    }
                    lst.add(rec);
                }
                linkedList = lst;
                Object var9_8 = null;
                if (null == rs) break block13;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return linkedList;
        try {
            ps.close();
            return linkedList;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return linkedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List selectFiredTriggerRecordsByJob(Connection conn, String jobName, String groupName) throws SQLException {
        SQLException ignore22;
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement ps;
        block13: {
            ps = null;
            ResultSet rs = null;
            try {
                LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
                if (jobName != null) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
                    ps.setString(1, jobName);
                    ps.setString(2, groupName);
                } else {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE JOB_GROUP = ?"));
                    ps.setString(1, groupName);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    FiredTriggerRecord rec = new FiredTriggerRecord();
                    rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                    rec.setFireInstanceState(rs.getString("STATE"));
                    rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                    rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                    rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
                    rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                    if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                        rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
                        rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                        rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                    }
                    lst.add(rec);
                }
                linkedList = lst;
                Object var9_8 = null;
                if (null == rs) break block13;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return linkedList;
        try {
            ps.close();
            return linkedList;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return linkedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List selectInstancesFiredTriggerRecords(Connection conn, String instanceName) throws SQLException {
        SQLException ignore22;
        LinkedList<FiredTriggerRecord> linkedList;
        PreparedStatement ps;
        block11: {
            ps = null;
            ResultSet rs = null;
            try {
                LinkedList<FiredTriggerRecord> lst = new LinkedList<FiredTriggerRecord>();
                ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ?"));
                ps.setString(1, instanceName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    FiredTriggerRecord rec = new FiredTriggerRecord();
                    rec.setFireInstanceId(rs.getString("ENTRY_ID"));
                    rec.setFireInstanceState(rs.getString("STATE"));
                    rec.setFireTimestamp(rs.getLong("FIRED_TIME"));
                    rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                    rec.setTriggerIsVolatile(rs.getBoolean("IS_VOLATILE"));
                    rec.setTriggerKey(new Key(rs.getString("TRIGGER_NAME"), rs.getString("TRIGGER_GROUP")));
                    if (!rec.getFireInstanceState().equals("ACQUIRED")) {
                        rec.setJobIsStateful(rs.getBoolean("IS_STATEFUL"));
                        rec.setJobRequestsRecovery(rs.getBoolean("REQUESTS_RECOVERY"));
                        rec.setJobKey(new Key(rs.getString("JOB_NAME"), rs.getString("JOB_GROUP")));
                    }
                    lst.add(rec);
                }
                linkedList = lst;
                Object var8_7 = null;
                if (null == rs) break block11;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var8_8 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return linkedList;
        try {
            ps.close();
            return linkedList;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return linkedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteFiredTrigger(Connection conn, String entryId) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE ENTRY_ID = ?"));
            ps.setString(1, entryId);
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int selectJobExecutionCount(Connection conn, String jobName, String jobGroup) throws SQLException {
        block12: {
            ps = null;
            rs = null;
            ps = conn.prepareStatement(this.rtp("SELECT COUNT(TRIGGER_NAME) FROM {0}FIRED_TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
            ps.setString(1, jobName);
            ps.setString(2, jobGroup);
            rs = ps.executeQuery();
            if (!rs.next()) break block14;
            var6_6 = rs.getInt(1);
            var9_7 = null;
            if (null == rs) break block12;
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl-1000
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl-1000:
        // 3 sources

        {
            block14: {
                return var6_6;
            }
            var7_13 = 0;
        }
        var9_8 = null;
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
        }
        if (null == ps) ** GOTO lbl43
        try {
            ps.close();
        }
        catch (SQLException ignore) {
            // empty catch block
        }
lbl43:
        // 3 sources

        return var7_13;
        catch (Throwable var8_14) {
            block15: {
                var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
                if (null == ps) break block15;
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
            throw var8_14;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
            ps.setBoolean(1, true);
            n = ps.executeUpdate();
            Object var5_4 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertSchedulerState(Connection conn, String instanceId, long checkInTime, long interval, String recoverer) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("INSERT INTO {0}SCHEDULER_STATE (INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL, RECOVERER) VALUES(?, ?, ?, ?)"));
            ps.setString(1, instanceId);
            ps.setLong(2, checkInTime);
            ps.setLong(3, interval);
            ps.setString(4, recoverer);
            n = ps.executeUpdate();
            Object var11_8 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteSchedulerState(Connection conn, String instanceId) throws SQLException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.rtp("DELETE FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
            ps.setString(1, instanceId);
            n = ps.executeUpdate();
            Object var6_5 = null;
            if (null == ps) return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (null == ps) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException ignore) {}
            throw throwable;
        }
        try {
            ps.close();
            return n;
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List selectSchedulerStateRecords(Connection conn, String instanceId) throws SQLException {
        SQLException ignore22;
        LinkedList<SchedulerStateRecord> linkedList;
        PreparedStatement ps;
        block12: {
            ps = null;
            ResultSet rs = null;
            try {
                LinkedList<SchedulerStateRecord> lst = new LinkedList<SchedulerStateRecord>();
                if (instanceId != null) {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE WHERE INSTANCE_NAME = ?"));
                    ps.setString(1, instanceId);
                } else {
                    ps = conn.prepareStatement(this.rtp("SELECT * FROM {0}SCHEDULER_STATE"));
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    SchedulerStateRecord rec = new SchedulerStateRecord();
                    rec.setSchedulerInstanceId(rs.getString("INSTANCE_NAME"));
                    rec.setCheckinTimestamp(rs.getLong("LAST_CHECKIN_TIME"));
                    rec.setCheckinInterval(rs.getLong("CHECKIN_INTERVAL"));
                    rec.setRecoverer(rs.getString("RECOVERER"));
                    lst.add(rec);
                }
                linkedList = lst;
                Object var8_7 = null;
                if (null == rs) break block12;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var8_8 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return linkedList;
        try {
            ps.close();
            return linkedList;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return linkedList;
    }

    protected final String rtp(String query) {
        return Util.rtp(query, this.tablePrefix);
    }

    protected ByteArrayOutputStream serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (null != obj) {
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            out.flush();
        }
        return baos;
    }

    protected ByteArrayOutputStream serializeJobData(JobDataMap data) throws IOException {
        if (this.canUseProperties()) {
            return this.serializeProperties(data);
        }
        if (null != data) {
            data.removeTransientData();
            return this.serializeObject(data);
        }
        return this.serializeObject(null);
    }

    private ByteArrayOutputStream serializeProperties(JobDataMap data) throws IOException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        if (null != data) {
            Properties properties = this.convertToProperty(data.getWrappedMap());
            properties.store(ba, "");
        }
        return ba;
    }

    protected Map convertFromProperty(Properties properties) throws IOException {
        HashMap data = new HashMap();
        Set keys = ((Hashtable)properties).keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = ((Hashtable)properties).get(key);
            data.put(key, val);
        }
        return data;
    }

    protected Properties convertToProperty(Map data) throws IOException {
        Properties properties = new Properties();
        Set keys = data.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object val = data.get(key);
            if (val == null) {
                val = "";
            }
            ((Hashtable)properties).put(key, val);
        }
        return properties;
    }

    protected Object getObjectFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        InputStream binaryInput;
        Object obj = null;
        Blob blobLocator = rs.getBlob(colName);
        if (blobLocator != null && null != (binaryInput = blobLocator.getBinaryStream())) {
            ObjectInputStream in = new ObjectInputStream(binaryInput);
            obj = in.readObject();
            in.close();
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
                ps.setBoolean(1, true);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("TRIGGER_NAME");
                    String groupName = rs.getString("TRIGGER_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key[] selectVolatileJobs(Connection conn) throws SQLException {
        SQLException ignore22;
        Key[] keyArray;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            try {
                ps = conn.prepareStatement(this.rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
                ps.setBoolean(1, true);
                rs = ps.executeQuery();
                ArrayList<Key> list = new ArrayList<Key>();
                while (rs.next()) {
                    String triggerName = rs.getString("JOB_NAME");
                    String groupName = rs.getString("JOB_GROUP");
                    list.add(new Key(triggerName, groupName));
                }
                Object[] oArr = list.toArray();
                Key[] kArr = new Key[oArr.length];
                System.arraycopy(oArr, 0, kArr, 0, oArr.length);
                keyArray = kArr;
                Object var9_8 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var9_9 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return keyArray;
        try {
            ps.close();
            return keyArray;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return keyArray;
    }

    protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException {
        if (this.canUseProperties()) {
            Blob blobLocator = rs.getBlob(colName);
            if (blobLocator != null) {
                InputStream binaryInput = blobLocator.getBinaryStream();
                return binaryInput;
            }
            return null;
        }
        return this.getObjectFromBlob(rs, colName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set selectPausedTriggerGroups(Connection conn) throws SQLException {
        SQLException ignore22;
        HashSet<String> hashSet;
        PreparedStatement ps;
        block10: {
            ps = null;
            ResultSet rs = null;
            HashSet<String> set = new HashSet<String>();
            try {
                ps = conn.prepareStatement(this.rtp("SELECT TRIGGER_GROUP FROM {0}PAUSED_TRIGGER_GRPS"));
                rs = ps.executeQuery();
                while (rs.next()) {
                    String groupName = rs.getString("TRIGGER_GROUP");
                    set.add(groupName);
                }
                hashSet = set;
                Object var7_6 = null;
                if (null == rs) break block10;
            }
            catch (Throwable throwable) {
                SQLException ignore22;
                Object var7_7 = null;
                if (null != rs) {
                    try {
                        rs.close();
                    }
                    catch (SQLException ignore22) {
                        // empty catch block
                    }
                }
                if (null == ps) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException ignore22) {}
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException ignore22) {
                // empty catch block
            }
        }
        if (null == ps) return hashSet;
        try {
            ps.close();
            return hashSet;
        }
        catch (SQLException ignore22) {
            // empty catch block
        }
        return hashSet;
    }
}

