/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NativeJob
implements Job {
    public static final String PROP_COMMAND = "command";
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_WAIT_FOR_PROCESS = "waitForProcess";
    static /* synthetic */ Class class$org$quartz$jobs$NativeJob;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String command = data.getString(PROP_COMMAND);
        String parameters = data.getString(PROP_PARAMETERS);
        if (parameters == null) {
            parameters = "";
        }
        boolean wait = true;
        data.containsKey(PROP_WAIT_FOR_PROCESS);
        wait = data.getBoolean(PROP_WAIT_FOR_PROCESS);
        this.runNativeCommand(command, parameters, wait);
    }

    private static Log getLog() {
        return LogFactory.getLog(class$org$quartz$jobs$NativeJob == null ? (class$org$quartz$jobs$NativeJob = NativeJob.class$("org.quartz.jobs.NativeJob")) : class$org$quartz$jobs$NativeJob);
    }

    private void runNativeCommand(String command, String parameters, boolean wait) throws JobExecutionException {
        String[] cmd = null;
        String[] args = new String[]{command, parameters};
        try {
            int i;
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows NT")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                i = 0;
                while (i < args.length) {
                    cmd[i + 2] = args[i];
                    ++i;
                }
            } else if (osName.equals("Windows 95")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "command.com";
                cmd[1] = "/C";
                i = 0;
                while (i < args.length) {
                    cmd[i + 2] = args[i];
                    ++i;
                }
            } else if (osName.equals("Windows 2000")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                i = 0;
                while (i < args.length) {
                    cmd[i + 2] = args[i];
                    ++i;
                }
            } else if (osName.equals("Windows XP")) {
                if (cmd == null) {
                    cmd = new String[args.length + 2];
                }
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
                i = 0;
                while (i < args.length) {
                    cmd[i + 2] = args[i];
                    ++i;
                }
            } else if (osName.equals("Linux")) {
                if (cmd == null) {
                    cmd = new String[args.length];
                }
                cmd = args;
            } else {
                if (cmd == null) {
                    cmd = new String[args.length];
                }
                cmd = args;
            }
            Runtime rt = Runtime.getRuntime();
            NativeJob.getLog().info("About to run" + cmd[0] + cmd[1]);
            Process proc = rt.exec(cmd);
            if (wait) {
                proc.waitFor();
            }
        }
        catch (Exception x) {
            System.out.println("error happened in native job");
            throw new JobExecutionException("Error launching native command: ", x, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

