/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs.ee.mail;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SendMailJob
implements Job {
    public static final String PROP_SMTP_HOST = "smtp_host";
    public static final String PROP_RECIPIENT = "recipient";
    public static final String PROP_CC_RECIPIENT = "cc_recipient";
    public static final String PROP_SENDER = "sender";
    public static final String PROP_REPLY_TO = "reply_to";
    public static final String PROP_SUBJECT = "subject";
    public static final String PROP_MESSAGE = "message";
    static /* synthetic */ Class class$org$quartz$jobs$ee$mail$SendMailJob;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data = context.getJobDetail().getJobDataMap();
        String smtpHost = data.getString(PROP_SMTP_HOST);
        String to = data.getString(PROP_RECIPIENT);
        String cc = data.getString(PROP_CC_RECIPIENT);
        String from = data.getString(PROP_SENDER);
        String replyTo = data.getString(PROP_REPLY_TO);
        String subject = data.getString(PROP_SUBJECT);
        String message = data.getString(PROP_MESSAGE);
        if (smtpHost == null || smtpHost.trim().length() == 0) {
            throw new IllegalArgumentException("PROP_SMTP_HOST not specified.");
        }
        if (to == null || to.trim().length() == 0) {
            throw new IllegalArgumentException("PROP_RECIPIENT not specified.");
        }
        if (from == null || from.trim().length() == 0) {
            throw new IllegalArgumentException("PROP_SENDER not specified.");
        }
        if (subject == null || subject.trim().length() == 0) {
            throw new IllegalArgumentException("PROP_SUBJECT not specified.");
        }
        if (message == null || message.trim().length() == 0) {
            throw new IllegalArgumentException("PROP_MESSAGE not specified.");
        }
        if (cc != null && cc.trim().length() == 0) {
            cc = null;
        }
        if (replyTo != null && replyTo.trim().length() == 0) {
            replyTo = null;
        }
        String mailDesc = "'" + subject + "' to: " + to;
        SendMailJob.getLog().info("Sending message " + mailDesc);
        try {
            this.sendMail(smtpHost, to, cc, from, replyTo, subject, message);
        }
        catch (MessagingException e) {
            throw new JobExecutionException("Unable to send mail: " + mailDesc, (Exception)((Object)e), false);
        }
    }

    private static Log getLog() {
        return LogFactory.getLog(class$org$quartz$jobs$ee$mail$SendMailJob == null ? (class$org$quartz$jobs$ee$mail$SendMailJob = SendMailJob.class$("org.quartz.jobs.ee.mail.SendMailJob")) : class$org$quartz$jobs$ee$mail$SendMailJob);
    }

    private void sendMail(String smtpHost, String to, String cc, String from, String replyTo, String subject, String message) throws MessagingException {
        MimeMessage mimeMessage = this.prepareMimeMessage(smtpHost, to, cc, from, replyTo, subject);
        mimeMessage.setText(message);
        Transport.send((Message)mimeMessage);
    }

    private MimeMessage prepareMimeMessage(String smtpHost, String to, String cc, String from, String replyTo, String subject) throws MessagingException {
        Properties properties = new Properties();
        ((Hashtable)properties).put("mail.smtp.host", smtpHost);
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session);
        InternetAddress[] toAddresses = InternetAddress.parse((String)to);
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
        if (cc != null) {
            InternetAddress[] ccAddresses = InternetAddress.parse((String)cc);
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
        }
        mimeMessage.setFrom((Address)new InternetAddress(from));
        if (replyTo != null) {
            mimeMessage.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
        }
        mimeMessage.setSubject(subject);
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

