/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.history;

import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.spi.SchedulerPlugin;

public class LoggingJobHistoryPlugin
implements SchedulerPlugin,
JobListener {
    private String name;
    private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String jobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    static /* synthetic */ Class class$org$quartz$plugins$history$LoggingJobHistoryPlugin;

    protected static Log getLog() {
        return LogFactory.getLog(class$org$quartz$plugins$history$LoggingJobHistoryPlugin == null ? (class$org$quartz$plugins$history$LoggingJobHistoryPlugin = LoggingJobHistoryPlugin.class$("org.quartz.plugins.history.LoggingJobHistoryPlugin")) : class$org$quartz$plugins$history$LoggingJobHistoryPlugin);
    }

    public String getJobSuccessMessage() {
        return this.jobSuccessMessage;
    }

    public String getJobFailedMessage() {
        return this.jobFailedMessage;
    }

    public String getJobToBeFiredMessage() {
        return this.jobToBeFiredMessage;
    }

    public void setJobSuccessMessage(String jobSuccessMessage) {
        this.jobSuccessMessage = jobSuccessMessage;
    }

    public void setJobFailedMessage(String jobFailedMessage) {
        this.jobFailedMessage = jobFailedMessage;
    }

    public void setJbFailedMessage(String jobFailedMessage) {
        this.setJobFailedMessage(jobFailedMessage);
    }

    public void setJobToBeFiredMessage(String jobToBeFiredMessage) {
        this.jobToBeFiredMessage = jobToBeFiredMessage;
    }

    public String getJobWasVetoedMessage() {
        return this.jobWasVetoedMessage;
    }

    public void setJobWasVetoedMessage(String jobWasVetoedMessage) {
        this.jobWasVetoedMessage = jobWasVetoedMessage;
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.name = name;
        scheduler.addGlobalJobListener(this);
    }

    public void start() {
    }

    public void shutdown() {
    }

    public String getName() {
        return this.name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (!LoggingJobHistoryPlugin.getLog().isInfoEnabled()) {
            return;
        }
        Trigger trigger = context.getTrigger();
        Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount())};
        LoggingJobHistoryPlugin.getLog().info(MessageFormat.format(this.getJobToBeFiredMessage(), args));
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Trigger trigger = context.getTrigger();
        Object[] args = null;
        if (jobException != null) {
            if (!LoggingJobHistoryPlugin.getLog().isWarnEnabled()) {
                return;
            }
            String errMsg = jobException.getMessage();
            args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()), errMsg};
            LoggingJobHistoryPlugin.getLog().warn(MessageFormat.format(this.getJobFailedMessage(), args), jobException);
        } else {
            if (!LoggingJobHistoryPlugin.getLog().isInfoEnabled()) {
                return;
            }
            String result = String.valueOf(context.getResult());
            args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount()), result};
            LoggingJobHistoryPlugin.getLog().info(MessageFormat.format(this.getJobSuccessMessage(), args));
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (!LoggingJobHistoryPlugin.getLog().isInfoEnabled()) {
            return;
        }
        Trigger trigger = context.getTrigger();
        Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), new Date(), trigger.getName(), trigger.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), new Integer(context.getRefireCount())};
        LoggingJobHistoryPlugin.getLog().info(MessageFormat.format(this.getJobWasVetoedMessage(), args));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

