/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private Runnable nextRunnable;
    private Object nextRunnableLock = new Object();
    private WorkerThread[] workers;
    private String threadNamePrefix = "SimpleThreadPoolWorker";
    static /* synthetic */ Class class$org$quartz$simpl$SimpleThreadPool;

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int threadCount, int threadPriority) {
        this.setThreadCount(threadCount);
        this.setThreadPriority(threadPriority);
    }

    public Log getLog() {
        return LogFactory.getLog(class$org$quartz$simpl$SimpleThreadPool == null ? (class$org$quartz$simpl$SimpleThreadPool = SimpleThreadPool.class$("org.quartz.simpl.SimpleThreadPool")) : class$org$quartz$simpl$SimpleThreadPool);
    }

    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int count) {
        this.count = count;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int prio) {
        this.prio = prio;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String prfx) {
        this.threadNamePrefix = prfx;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader) {
        this.inheritLoader = inheritLoader;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup) {
        this.inheritGroup = inheritGroup;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public void initialize() throws SchedulerConfigException {
        if (this.count <= 0 || this.count > 200) {
            throw new SchedulerConfigException("Thread count must be > 0 and <= 200");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.threadGroup = parent;
                parent = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup(parent, "SimpleThreadPool");
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        this.workers = new WorkerThread[this.count];
        int i = 0;
        while (i < this.count) {
            this.workers[i] = new WorkerThread(this, this.threadGroup, this.getThreadNamePrefix() + "-" + i, this.prio, this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                this.workers[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            ++i;
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.isShutdown = true;
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] != null) {
                this.workers[i].shutdown();
            }
            ++i;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.nextRunnableLock.notifyAll();
        }
        if (waitForJobsToComplete) {
            int alive = this.workers.length;
            while (alive > 0) {
                alive = 0;
                int i2 = 0;
                while (i2 < this.workers.length) {
                    if (this.workers[i2].isAlive()) {
                        try {
                            this.getLog().debug("Waiting for thread no. " + i2 + " to shut down");
                            ++alive;
                            this.workers[i2].join(200L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
            }
            int activeCount = this.threadGroup.activeCount();
            if (activeCount > 0) {
                this.getLog().info("There are still " + activeCount + " worker threads active." + " See javadoc runInThread(Runnable) for a possible explanation");
            }
            this.getLog().debug("shutdown complete");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        if (this.isShutdown) {
            try {
                this.getLog().info("SimpleThreadPool.runInThread(): thread pool has been shutdown. Runnable will not be executed");
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while (this.nextRunnable != null && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.isShutdown) {
                this.nextRunnable = runnable;
                this.nextRunnableLock.notifyAll();
            }
        }
        if (!this.isShutdown) return true;
        new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, false, runnable);
        return true;
    }

    private Runnable getNextRunnable() throws InterruptedException {
        Runnable toRun = null;
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (this.nextRunnable == null) {
                this.nextRunnableLock.wait(1000L);
            }
            if (this.nextRunnable != null) {
                toRun = this.nextRunnable;
                this.nextRunnable = null;
                this.nextRunnableLock.notifyAll();
            }
        }
        return toRun;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WorkerThread
    extends Thread {
        private boolean run = true;
        private SimpleThreadPool tp;
        private Runnable runnable = null;

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon) {
            this(tp, threadGroup, name, prio, isDaemon, null);
        }

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable) {
            super(threadGroup, name);
            this.tp = tp;
            this.runnable = runnable;
            this.setPriority(prio);
            this.setDaemon(isDaemon);
            this.start();
        }

        void shutdown() {
            this.run = false;
        }

        public void run() {
            boolean runOnce = this.runnable != null;
            while (this.run) {
                Object var6_8;
                this.setPriority(this.tp.getThreadPriority());
                try {
                    block17: {
                        try {
                            if (this.runnable == null) {
                                this.runnable = this.tp.getNextRunnable();
                            }
                            if (this.runnable == null) break block17;
                            this.runnable.run();
                        }
                        catch (InterruptedException unblock) {
                            try {
                                SimpleThreadPool.this.getLog().error("worker threat got 'interrupt'ed.", unblock);
                            }
                            catch (Exception e) {
                            }
                            var6_8 = null;
                            if (runOnce) {
                                this.run = false;
                            }
                            this.runnable = null;
                            continue;
                        }
                        catch (Exception exceptionInRunnable) {
                            try {
                                SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable);
                            }
                            catch (Exception e) {
                            }
                            var6_8 = null;
                            if (runOnce) {
                                this.run = false;
                            }
                            this.runnable = null;
                            continue;
                        }
                    }
                    var6_8 = null;
                    if (runOnce) {
                        this.run = false;
                    }
                    this.runnable = null;
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    if (runOnce) {
                        this.run = false;
                    }
                    this.runnable = null;
                    throw throwable;
                }
            }
            try {
                SimpleThreadPool.this.getLog().debug("WorkerThread is shutting down");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

