/*
 * Decompiled with CFR 0.152.
 */
package qed;

import java.net.URL;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;

public class QEDClient {
    static Logger logger = Logger.getLogger(class$qed$QEDClient == null ? (class$qed$QEDClient = QEDClient.class$("qed.QEDClient")) : class$qed$QEDClient);
    static /* synthetic */ Class class$qed$QEDClient;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        logger.info("Starting QEDClient");
        PosixParser parser = new PosixParser();
        Options options = new Options();
        CommandLine cmd = null;
        int port = 8081;
        boolean printHelp = false;
        options.addOption("p", "port", true, "XML-RPC Port to connect to, 8081 is default");
        options.addOption("s", "server", true, "Server to connect to, localhost is default");
        options.addOption("h", "help", false, "Print help message");
        options.addOption("o", "population", true, "Return the a PopulationId");
        try {
            cmd = parser.parse(options, args);
        }
        catch (Exception e) {
            logger.error("Failed to parse commandline", e);
            printHelp = true;
        }
        String[] files = cmd.getArgs();
        if (cmd.hasOption("h") || printHelp || files.length < 1) {
            new HelpFormatter().printHelp("QEDClient [options] <QED Project>", options);
            System.exit(0);
        }
        try {
            port = Integer.parseInt(cmd.getOptionValue("p", "8081"));
        }
        catch (Exception e) {
            logger.error(cmd.getOptionValue("p", "8081") + " is not a valid port number");
            System.exit(1);
        }
        String project = files[0];
        XmlRpcClient client = null;
        try {
            client = new XmlRpcClient(new URL("http://" + cmd.getOptionValue("s", "localhost") + ":" + port + "/" + project + "/Command/"));
        }
        catch (Exception e) {
            logger.error("Failed to create XmlRpcClient", e);
            System.exit(1);
        }
        if (cmd.hasOption("o")) {
            String name = cmd.getOptionValue("o");
            try {
                Vector<String> arguments = new Vector<String>();
                arguments.addElement(cmd.getOptionValue("o"));
                Integer populationId = (Integer)client.execute("Write.getPopulation", arguments);
                logger.info("Got: " + populationId);
            }
            catch (Exception e) {
                logger.error("Failed to create or get population " + name, e);
                System.exit(1);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

