/*
 * Decompiled with CFR 0.152.
 */
package qed.server;

import dart.server.Container;
import dart.server.Server;
import dart.server.wrap.TaskQueueEntity;
import dart.server.wrap.TaskQueueFinderBase;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.sourceforge.jaxor.JaxorContextImpl;
import net.sourceforge.jaxor.QueryParams;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.xmlrules.FromXmlRuleSet;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpServer;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.http.handler.ResourceHandler;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

public class QED
extends Container {
    static Logger logger = Logger.getLogger(class$qed$server$QED == null ? (class$qed$server$QED = QED.class$("qed.server.QED")) : class$qed$server$QED);
    static Properties statsDefaults = new Properties();
    File dataDirectory = null;
    File measurementDirectory = null;
    ArrayList Tasks = new ArrayList();
    Properties stats = new Properties();
    Properties properties = new Properties();
    HttpServer httpServer = null;
    Scheduler scheduler = null;
    static /* synthetic */ Class class$qed$server$QED;
    static /* synthetic */ Class class$dart$server$task$Task;
    static /* synthetic */ Class class$dart$server$task$ScheduledTask;
    static /* synthetic */ Class class$dart$server$Project;
    static /* synthetic */ Class class$dart$server$Server;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("QED: " + this.title + "\n");
        buffer.append("Table Counts: \n");
        Connection connection = this.database.getConnection();
        String[] Tables = new String[]{"Population", "Subject", "Experiment", "Run", "Measurement"};
        try {
            for (int i = 0; i < Tables.length; ++i) {
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery("select count(*) as c from " + Tables[i]);
                rs.next();
                buffer.append("\t" + Tables[i] + ": " + rs.getInt("c") + "\n");
            }
            connection.close();
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to fetch counts", e);
        }
        buffer.append(this.database.toString() + "\n");
        buffer.append(this.servletManager.toString() + "\n");
        return buffer.toString();
    }

    public Properties getStats() {
        return this.stats;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public void incrementStatistic(String key) {
        this.incrementStatistic(key, 1);
    }

    public void incrementStatistic(String key, int i) {
        if (!this.stats.containsKey(key)) {
            logger.debug(this.title + ": Did not find key: " + key + " in statistics, setting to zero");
            this.stats.put(key, "0");
        }
        int v = Integer.parseInt((String)this.stats.get(key)) + i;
        this.stats.put(key, Integer.toString(v));
    }

    public void incrementStatistic(String key, double i) {
        if (!this.stats.containsKey(key)) {
            logger.debug(this.title + ": Did not find key: " + key + " in statistics, setting to zero");
            this.stats.put(key, "0.0");
        }
        double v = Double.parseDouble((String)this.stats.get(key)) + i;
        this.stats.put(key, Double.toString(v));
    }

    public void setBaseDirectory(String d) {
        super.setBaseDirectory(d);
        this.measurementDirectory = new File(d, "Measurement");
        if (!this.measurementDirectory.exists()) {
            this.measurementDirectory.mkdir();
        }
    }

    public File getMeasurementDirectory() {
        return this.measurementDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateProjectRelativeFileForBinary(byte[] b, String suffix) {
        File file = this.measurementDirectory;
        synchronized (file) {
            String filename;
            File file2;
            StringBuffer hash = new StringBuffer();
            try {
                MessageDigest algorithm = MessageDigest.getInstance("MD5");
                algorithm.reset();
                algorithm.update(b);
                byte[] digest = algorithm.digest();
                for (int j = 0; j < digest.length; ++j) {
                    String hexChar = Integer.toHexString(0xFF & digest[j]);
                    while (hexChar.length() < 2) {
                        hexChar = '0' + hexChar;
                    }
                    hash.append(hexChar);
                }
            }
            catch (Exception e) {
                logger.error(this.title + ": Failed to generate MD5 hash", e);
            }
            String base = hash.substring(0, 2) + File.separator + hash.substring(2, 4) + File.separator + hash.substring(4, 6) + File.separator + hash.toString();
            int count = -1;
            do {
                filename = count == -1 ? base + suffix : base + "-" + count + suffix;
                ++count;
            } while ((file2 = new File(this.getMeasurementDirectory(), filename)).exists() && (!file2.exists() || file2.length() != (long)b.length));
            file2 = new File(filename);
            return file2;
        }
    }

    public void addTask(String Type2, String Schedule, Properties properties) {
        logger.debug(this.title + ": Adding Task: " + Type2 + " Schedule: " + Schedule + " Properties: " + properties);
        this.Tasks.add(new Object[]{Type2, Schedule, properties});
    }

    public void start(Server server) throws Exception {
        this.dartServer = server;
        this.scheduler = this.dartServer.getScheduler();
        this.httpServer = this.dartServer.getHttpServer();
        logger.info(this.title + ": Starting project");
        try {
            logger.debug(this.title + ": Loading statistics");
            File f = new File(this.getBaseDirectory(), "Statistics.txt");
            if (f.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                this.stats.load(in);
            }
        }
        catch (Exception e) {
            logger.error(this.title + ": Error loading statistics!", e);
        }
        this.incrementStatistic("Startups");
        if (this.database == null) {
            throw new Exception("Database has not been defined");
        }
        this.commandManager.start(this);
        this.database.start(this);
        for (int i = 0; i < this.Tasks.size(); ++i) {
            Object[] o = (Object[])this.Tasks.get(i);
            String Type2 = null;
            String Schedule = null;
            Properties properties = null;
            Class<?> c = null;
            try {
                o = (Object[])this.Tasks.get(i);
                Type2 = (String)o[0];
                Schedule = (String)o[1];
                properties = (Properties)o[2];
                c = Class.forName(Type2);
                if ((class$dart$server$task$Task == null ? QED.class$("dart.server.task.Task") : class$dart$server$task$Task).isAssignableFrom(c)) {
                    JobDetail detail = new JobDetail(this.title + ":" + Type2 + ":" + i, this.title, class$dart$server$task$ScheduledTask == null ? QED.class$("dart.server.task.ScheduledTask") : class$dart$server$task$ScheduledTask);
                    detail.getJobDataMap().put((Object)"QED", this);
                    detail.getJobDataMap().put("Type", Type2);
                    detail.getJobDataMap().put((Object)"Properties", properties);
                    CronTrigger trigger = new CronTrigger(this.title + ":" + i, this.title, Schedule);
                    if (properties.containsKey("Description")) {
                        trigger.setDescription(this.title + ": " + properties.get("Description"));
                    } else {
                        trigger.setDescription(this.title + ": " + Type2);
                    }
                    this.scheduler.scheduleJob(detail, trigger);
                    logger.debug(this.title + ": Started " + this.title);
                    continue;
                }
                logger.error(this.title + ": Class: " + Type2 + " is not a " + (class$dart$server$task$Task == null ? QED.class$("dart.server.task.Task") : class$dart$server$task$Task));
                continue;
            }
            catch (Exception e) {
                logger.error(this.title + ": could not find class: " + Type2, e);
            }
        }
        try {
            logger.debug(this.title + ": Creating HTTP context with context path /" + this.title + "/*");
            HttpContext httpContext = this.httpServer.getContext("/" + this.title + "/*");
            logger.debug(this.title + ": Setting resource base to " + this.htmlDirectory.getAbsolutePath());
            httpContext.setResourceBase(this.htmlDirectory.getAbsolutePath());
            logger.info(this.title + ": Adding Plugins directory to classpath");
            httpContext.addClassPath(this.pluginsDirectory.toString());
            File[] jars = this.pluginsDirectory.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                if (!jars[i].isFile()) continue;
                logger.info(this.title + ": Adding " + jars[i].toString() + " to classpath");
                httpContext.addClassPath(jars[i].toString());
            }
            this.servletManager.start(this, httpContext);
            ResourceHandler handler = new ResourceHandler();
            handler.setDirAllowed(true);
            handler.setAcceptRanges(true);
            httpContext.addHandler(handler);
            httpContext.addHandler(new NotFoundHandler());
            logger.debug(this.title + ": Creating HTTP context with context path /" + this.title + "/Data/*");
            HttpContext measurementContext = this.httpServer.getContext("/" + this.title + "/Measurement/*");
            logger.debug(this.title + ": Setting resource base to " + this.measurementDirectory.getAbsolutePath());
            measurementContext.setResourceBase(this.measurementDirectory.getAbsolutePath());
            handler = new ResourceHandler();
            handler.setDirAllowed(true);
            handler.setAcceptRanges(true);
            measurementContext.addHandler(handler);
        }
        catch (Exception e) {
            logger.error("Failed to create HTTP context", e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueTask(String TaskType, Properties properties, int priority) {
        Connection connection = this.getConnection();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String propString = null;
        try {
            properties.store(out, null);
            propString = out.toString().split("\n", 2)[1];
            JaxorContextImpl session = new JaxorContextImpl(connection);
            TaskQueueFinderBase finder = new TaskQueueFinderBase(session);
            QueryParams params = new QueryParams();
            params.add(new Integer(priority));
            params.add(TaskType);
            params.add(propString);
            if (finder.asQuery("select * from taskqueue where Priority=? and Type=? and Properties=?", params).list().size() != 0) {
                return;
            }
            TaskQueueEntity task = finder.newInstance();
            task.setPriority(new Integer(priority));
            task.setType(TaskType);
            task.setProperties(propString);
            session.commit();
            logger.debug(this.title + ": Queued: " + TaskType + "\nProperties: " + propString);
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to add Task: " + TaskType + " to queue with priority: " + priority + " properties:\n" + propString, e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
    }

    public void initializeDatabase() {
        File schema = new File(this.baseDirectory, "QEDSchema.sql");
        if (!schema.exists()) {
            logger.error(this.title + ": Schema file: " + schema.getPath() + " does not exist");
            return;
        }
        this.executeSQL(schema);
    }

    public static void generateSchema(String DBType, File f) {
        if (f.exists()) {
            logger.error("Error generating schema, file: " + f.getPath() + " exists");
            return;
        }
        try {
            BufferedWriter outTemplate = new BufferedWriter(new FileWriter(f));
            Server.generateSchema(DBType, outTemplate, "qed/Resources/Server/QEDSchema.sql");
        }
        catch (Exception e) {
            logger.error("Failed to generate schema file: " + f.getPath(), e);
        }
    }

    public void shutdown() throws Exception {
        try {
            this.commandManager.shutdown();
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to shutdown CommandManager", e);
        }
        try {
            this.database.shutdown();
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to shutdown Database", e);
        }
    }

    public void refreshResources() {
        if (!this.temporaryDirectory.exists()) {
            this.temporaryDirectory.mkdir();
        }
        if (!this.measurementDirectory.exists()) {
            this.measurementDirectory.mkdir();
        }
        if (!this.htmlDirectory.exists()) {
            this.htmlDirectory.mkdir();
        }
        if (!this.templatesDirectory.exists()) {
            this.templatesDirectory.mkdir();
        }
        URL resourceRootURL = (class$dart$server$Project == null ? (class$dart$server$Project = QED.class$("dart.server.Project")) : class$dart$server$Project).getClassLoader().getResource("qed/Resources/QED/Style.css");
        logger.info("Default project resources root path is " + resourceRootURL.toString());
        FileObject dest = null;
        FileObject src = null;
        FileObject templates = null;
        try {
            FileSystemManager fsManager = VFS.getManager();
            logger.debug("New Resource Root:" + resourceRootURL.toString().replaceAll("jar:file:", "jar://"));
            logger.debug("Resource Root:" + resourceRootURL.toString());
            src = fsManager.resolveFile(resourceRootURL.toString()).getParent();
            logger.debug("Src exists: " + src.exists());
            File destinationDirectory = new File(this.htmlDirectory, "Resources").getAbsoluteFile();
            dest = fsManager.resolveFile(destinationDirectory.toString());
            templates = dest.getParent().getParent().resolveFile("Templates");
            logger.debug("src: " + src.toString());
            logger.debug("dest: " + dest.toString());
            logger.debug("templates: " + templates.toString());
            logger.debug("Copy Templates");
            if (!src.resolveFile("Templates").exists()) {
                logger.debug("Could not find Templates in src");
            }
            templates.copyFrom(src.resolveFile("Templates"), new AllFileSelector());
            logger.debug("Copy Resources");
            dest.copyFrom(src, new FileSelector(){

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates");
                }

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return !info.getFile().getName().getBaseName().equals("Templates");
                }
            });
        }
        catch (Exception e) {
            logger.error(this.title + ": Failed to refresh resources", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createQED(String path, String db) throws Exception {
        Writer outTemplate;
        block11: {
            File dir = new File(path).getAbsoluteFile();
            if (dir.exists()) {
                logger.error("Directory: " + path + " exists, can not create new project");
                throw new Exception("Directory: " + path + " exists, can not create new project");
            }
            String name = dir.getName();
            logger.info("Creating new QED: " + path + " " + name + " " + db);
            outTemplate = null;
            logger.debug("Creating directory " + dir.toString());
            dir.mkdirs();
            Configuration cfg = new Configuration();
            cfg.setClassForTemplateLoading(class$dart$server$Server == null ? (class$dart$server$Server = QED.class$("dart.server.Server")) : class$dart$server$Server, "/");
            Template template = cfg.getTemplate("qed/Resources/Server/QEDDefaults.xml");
            outTemplate = new BufferedWriter(new FileWriter(new File(dir, "QED.xml")));
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("Name", name);
            root.put("Directory", dir.toString());
            if (db != null) {
                root.put("Type", db.toLowerCase());
            } else {
                root.put("Type", "derby");
            }
            template.process(root, outTemplate);
            outTemplate.flush();
            if (db == null) break block11;
            QED.generateSchema(db, new File(dir, "QEDSchema.sql"));
        }
        Object var9_9 = null;
        if (outTemplate == null) return;
        try {
            outTemplate.close();
            return;
        }
        catch (IOException e2) {
            logger.error("Failed to close output stream", e2);
        }
        return;
        {
            catch (Exception e) {
                logger.error("Error creating default project", e);
                Object var9_10 = null;
                if (outTemplate == null) return;
                try {
                    outTemplate.close();
                    return;
                }
                catch (IOException e2) {
                    logger.error("Failed to close output stream", e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (outTemplate == null) throw throwable;
            try {
                outTemplate.close();
                throw throwable;
            }
            catch (IOException e2) {
                logger.error("Failed to close output stream", e2);
            }
            throw throwable;
        }
    }

    public static QED loadQED(String inPath) {
        File path = new File(inPath);
        if (path.isDirectory()) {
            path = new File(path, "QED.xml");
        }
        QED qed = null;
        try {
            URL rules = (class$dart$server$Server == null ? (class$dart$server$Server = QED.class$("dart.server.Server")) : class$dart$server$Server).getClassLoader().getResource("qed/Resources/Server/QEDCreationRules.xml");
            logger.debug("Found QEDCreationRules.xml at: " + rules);
            Digester digester = new Digester();
            digester.setRules(new ExtendedBaseRules());
            digester.addRuleSet(new FromXmlRuleSet(rules));
            logger.info("Processed rules, starting to parse");
            qed = (QED)digester.parse(path);
            logger.info("Parsed to create a project");
        }
        catch (Exception e) {
            logger.error("Failed to create project", e);
        }
        return qed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

