/*
 * Decompiled with CFR 0.152.
 */
package qed.server.servlet;

import dart.server.Server;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jaxor.JaxorContextImpl;
import org.apache.log4j.Logger;
import qed.server.QED;
import qed.server.wrap.ExperimentFinderBase;
import qed.server.wrap.PopulationEntity;
import qed.server.wrap.PopulationFinderBase;
import qed.server.wrap.PopulationList;
import qed.server.wrap.RunFinderBase;
import qed.server.wrap.SubjectFinderBase;

public class View
extends HttpServlet {
    static Logger logger = Logger.getLogger(class$qed$server$servlet$View == null ? (class$qed$server$servlet$View = View.class$("qed.server.servlet.View")) : class$qed$server$servlet$View);
    static /* synthetic */ Class class$qed$server$servlet$View;

    void error(PrintWriter out, String title, String msg, HashMap map) {
        String projectName = (String)map.get("projectName");
        out.println("<html><head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h1>Dashboard for ");
        out.println(projectName);
        out.println("</h1>");
        out.println("<p>");
        out.println(msg);
        out.println("<p>");
        out.println("</body>");
        out.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        QED qed;
        String templateName = req.getPathInfo();
        if (templateName == null) {
            res.sendRedirect(req.getRequestURL() + "/");
            return;
        }
        if (templateName.equals("/")) {
            RequestDispatcher dispatcher = req.getRequestDispatcher("View");
            dispatcher.forward(req, res);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("request", req);
        map.put("response", res);
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        map.put("out", out);
        String qedName = this.getInitParameter("qed");
        map.put("name", qedName);
        try {
            qed = Server.getQED(qedName);
            if (qed == null) {
                logger.debug(qed.getTitle() + ": not found");
                this.error(out, "Dart Dashboard", "Dart: no qed found matching \"" + qedName + "\"", map);
                out.close();
                return;
            }
        }
        catch (Exception e) {
            logger.debug(qedName + ": error getting qed");
            this.error(out, "Dart Dashboard", "Dart: Error accessing qed \"" + qedName + "\"", map);
            out.close();
            return;
        }
        map.put("qed", qed);
        try {
            this.findTemplate(map);
        }
        catch (Exception e) {
            logger.error("Failed to find template", e);
            this.error(out, "Dart Dashboard", "Dart: Failed to find or parse template: \"" + (String)map.get("templateName") + "\"", map);
            out.close();
            return;
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("qedName", qedName);
        root.put("qedProperties", qed.getProperties());
        Map parameters = req.getParameterMap();
        root.put("parameters", parameters);
        Connection connection = qed.getConnection();
        try {
            connection.setReadOnly(true);
        }
        catch (Exception e) {
            logger.error(qed.getTitle() + ": Could not set connection to ReadOnly, possible security hole!", e);
        }
        JaxorContextImpl jaxorContext = new JaxorContextImpl(connection);
        PopulationFinderBase populationFinder = new PopulationFinderBase(jaxorContext);
        SubjectFinderBase subjectFinder = new SubjectFinderBase(jaxorContext);
        ExperimentFinderBase experimentFinder = new ExperimentFinderBase(jaxorContext);
        RunFinderBase runFinder = new RunFinderBase(jaxorContext);
        if (parameters.containsKey("populationid")) {
            String[] ids = (String[])parameters.get("populationid");
            if (ids[0].equals("all")) {
                PopulationList list = populationFinder.query("select * from population");
                root.put("populations", list);
            } else {
                PopulationEntity population = populationFinder.selectByPopulationId(new Integer(ids[0]));
                root.put("population", population);
            }
        } else {
            PopulationList list = populationFinder.query("select * from population");
            root.put("populations", list);
        }
        try {
            Template template = (Template)map.get("template");
            template.process(root, out);
        }
        catch (Exception e) {
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {}
        }
        out.close();
    }

    void findTemplate(HashMap map) throws Exception {
        HttpServletRequest request = (HttpServletRequest)map.get("request");
        QED qed = (QED)map.get("qed");
        String templateName = request.getPathInfo();
        map.put("templateName", templateName);
        Configuration cfg = new Configuration();
        File resourcesDirectory = new File(qed.getBaseDirectory(), "Templates");
        cfg.setDirectoryForTemplateLoading(resourcesDirectory);
        Template template = cfg.getTemplate(templateName + ".ftl");
        map.put("template", template);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

